package com.biz.crm.mdm.business.productlevel.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;

/**
 * 产品层级类型
 *
 * @author Liao.Hua
 * @date 2020-09-01 17:47:01
 */
public enum ProductLevelEnum {

  max("max", "大类"),
  min("min", "小类"),
  brand("brand", "品牌"),
  series("series", "系列");

  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ProductLevelEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ProductLevelEnum codeToEnum(String code) {
    ProductLevelEnum result = null;
    for (ProductLevelEnum productLevelEnum : ProductLevelEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
