package com.biz.crm.mdm.business.productlevel.sdk.event;

import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;

import java.util.List;

/**
 * 产品层级事件监听
 * Created by Bao Hongbin on 2021-10-12 16:55.
 */
public interface ProductLevelEventListener {
  /**
   * 当新增产品层级时通知监听
   *
   * @param productLevelVos
   */
  void onBatchCreate(List<ProductLevelVo> productLevelVos);

  /**
   * 当更新产品层级时通知监听
   *
   * @param productLevelVos
   */
  void onBatchUpdate(List<ProductLevelVo> productLevelVos);

  /**
   * 当删除产品层级时通知监听
   *
   * @param productLevelVos
   */
  void onBatchDelete(List<ProductLevelVo> productLevelVos);

  /**
   * 当启用产品层级时通知监听
   *
   * @param productLevelVos
   */
  void onBatchEnable(List<ProductLevelVo> productLevelVos);


  /**
   * 当禁用产品层级时通知监听
   *
   * @param eventDtos
   */
  void onBatchDisable(List<ProductLevelVo> eventDtos);

}
