package com.biz.crm.mdm.business.productlevel.sdk.service;
/**
 * Created by Bao Hongbin on 2021-10-14 14:45.
 */

import com.biz.crm.mdm.business.productlevel.sdk.vo.ProductLevelVo;

import java.util.List;

/**
 * @program: crm
 * @description: 产品层级vo SDK 服务
 * @author: Bao Hongbin
 * @create: 2021-10-14 14:45
 **/
public interface ProductLevelVoSdkService {

  /**
   * 通过id查询产品层级
   *
   * @param id
   * @return
   */
  ProductLevelVo findDetailsById(String id);


  /**
   * 通过ids查询产品层级
   *
   * @param ids
   * @return
   */
  List<ProductLevelVo> findListByIds(List<String> ids);

  /**
   * 通过code查询产品层级
   *
   * @param code
   * @return
   */
  ProductLevelVo findDetailsByCode(String code);


  /**
   * 通过codes查询产品层级
   *
   * @param codes
   * @return
   */
  List<ProductLevelVo> findListByCodes(List<String> codes);


  /**
   * 根据产品层级编码查询该产品层级及全部下级层级的编码
   *
   * @param productLevelCode
   * @return
   */
  List<String> findCurAndChildrenCodesByCode(String productLevelCode);




}
