/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promoters.feign.feign.PromotersVoServiceFeign;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PromotersVoServiceImpl
implements PromotersVoService {
    private static final Logger log = LoggerFactory.getLogger(PromotersVoServiceImpl.class);
    @Autowired(required=false)
    private PromotersVoServiceFeign promotersVoServiceFeign;

    public Page<PromotersVo> findByConditions(Pageable pageable, PromotersDto dto) {
        Result<Page<PromotersVo>> result = this.promotersVoServiceFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Page)result.getResult();
    }

    public PromotersVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Result<PromotersVo> result = this.promotersVoServiceFeign.findById(id);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (PromotersVo)result.getResult();
    }

    public List<PromotersVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.findByIds(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public PromotersVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Result<PromotersVo> result = this.promotersVoServiceFeign.findByCode(code);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (PromotersVo)result.getResult();
    }

    public List<PromotersVo> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.findByCodes(codeList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<PromotersVo> findByIdCard(List<String> idCardList) {
        if (CollectionUtils.isEmpty(idCardList)) {
            return Collections.emptyList();
        }
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.findByIdCard(idCardList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<PromotersVo> createOrUpdate(List<PromotersDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.createOrUpdate(dtoList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public PromotersVo create(PromotersDto dto) {
        this.commonValidate(dto);
        Result<PromotersVo> result = this.promotersVoServiceFeign.create(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (PromotersVo)result.getResult();
    }

    public PromotersVo update(PromotersDto dto) {
        this.commonValidate(dto);
        Validate.notBlank((CharSequence)dto.getEmployeeCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<PromotersVo> result = this.promotersVoServiceFeign.update(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (PromotersVo)result.getResult();
    }

    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<?> result = this.promotersVoServiceFeign.delete(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    private void commonValidate(PromotersDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.promotersVoServiceFeign.enable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.promotersVoServiceFeign.disable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public List<PromotersVo> findSelectList(PromotersSelectDto dto) {
        throw new UnsupportedOperationException();
    }

    public List<PromotersVo> findTerminalPromoters(PromotersDto dto) {
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.findTerminalPromoters(dto);
        if (result.isSuccess()) {
            return (List)result.getResult();
        }
        return Lists.newArrayList();
    }

    public List<PromotersVo> findTerminalPromotersByTerminal(PromotersDto dto) {
        Result<List<PromotersVo>> result = this.promotersVoServiceFeign.findTerminalPromotersByTerminal(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }
}

