/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promoters.feign.feign.TerminalPromotersVoServiceFeign;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TerminalPromotersVoServiceImpl
implements TerminalPromotersVoService {
    private static final Logger log = LoggerFactory.getLogger(TerminalPromotersVoServiceImpl.class);
    @Autowired(required=false)
    private TerminalPromotersVoServiceFeign terminalPromotersVoServiceFeign;

    public Page<TerminalPromotersVo> findByConditions(Pageable pageable, TerminalPromotersDto dto) {
        Result<Page<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (Page)result.getResult();
    }

    public TerminalPromotersVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Result<TerminalPromotersVo> result = this.terminalPromotersVoServiceFeign.findById(id);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (TerminalPromotersVo)result.getResult();
    }

    public List<TerminalPromotersVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByIds(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByTerminalCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByTerminalCode(code);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByTerminalCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByTerminalCodes(codeList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByEmployeeCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByEmployeeCode(code);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByEmployeeCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByEmployeeCodes(codeList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByCustomerCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByCustomerCode(code);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> findByCustomerCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.findByCustomerCodes(codeList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public List<TerminalPromotersVo> createOrUpdate(List<TerminalPromotersDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Result<List<TerminalPromotersVo>> result = this.terminalPromotersVoServiceFeign.createOrUpdate(dtoList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (List)result.getResult();
    }

    public TerminalPromotersVo create(TerminalPromotersDto dto) {
        this.commonValidate(dto);
        Result<TerminalPromotersVo> result = this.terminalPromotersVoServiceFeign.create(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (TerminalPromotersVo)result.getResult();
    }

    public TerminalPromotersVo update(TerminalPromotersDto dto) {
        this.commonValidate(dto);
        Validate.notBlank((CharSequence)dto.getEmployeeCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<TerminalPromotersVo> result = this.terminalPromotersVoServiceFeign.update(dto);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
        return (TerminalPromotersVo)result.getResult();
    }

    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Result<?> result = this.terminalPromotersVoServiceFeign.delete(idList);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    private void commonValidate(TerminalPromotersDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getTerminalCode(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getEmployeeCode(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.terminalPromotersVoServiceFeign.enable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Result<?> result = this.terminalPromotersVoServiceFeign.disable(ids);
        Assert.isTrue((boolean)result.isSuccess(), (String)result.getMessage());
    }

    public Page<PromotersVo> findPromotersByTerminalCodes(Pageable pageable, List<String> terminalCodeList) {
        throw new UnsupportedOperationException();
    }
}

