package com.biz.crm.mdm.business.promoters.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 门店促销人员关系管理
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 23:41
 */
@Slf4j
@Api(tags = "门店促销人员关系管理: TerminalPromotersVo: 门店促销人员关系")
@RestController
@RequestMapping(value = {"/v1/terminal/terminalPromotersVo"})
public class TerminalPromotersVoController {

    @Autowired(required = false)
    private TerminalPromotersVoService terminalPromotersVoService;

    /**
     * 查询分页列表
     *
     * @param pageable 分页信息
     * @param dto      查询参数
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:51
     */
    @ApiOperation(value = "查询分页列表")
    @GetMapping(value = {"/findByConditions"})
    public Result<Page<TerminalPromotersVo>> findByConditions(@PageableDefault(50) Pageable pageable, TerminalPromotersDto dto) {
        try {
            Page<TerminalPromotersVo> result = this.terminalPromotersVoService.findByConditions(pageable, dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "批量新增或修改")
    @PostMapping("createOrUpdate")
    public Result<List<TerminalPromotersVo>> createOrUpdate(@RequestBody List<TerminalPromotersDto> dtoList) {
        try {
            List<TerminalPromotersVo> result = this.terminalPromotersVoService.createOrUpdate(dtoList);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "新增")
    @PostMapping("create")
    public Result<TerminalPromotersVo> create(@ApiParam(name = "dto", value = "门店促销人员关系") @RequestBody TerminalPromotersDto dto) {
        try {
            TerminalPromotersVo result = this.terminalPromotersVoService.create(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "修改")
    @PatchMapping("update")
    public Result<TerminalPromotersVo> update(@ApiParam(name = "dto", value = "门店促销人员关系") @RequestBody TerminalPromotersDto dto) {
        try {
            TerminalPromotersVo result = this.terminalPromotersVoService.update(dto);
            return Result.ok(result);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "删除")
    @DeleteMapping("delete")
    public Result<?> delete(@ApiParam(name = "idList", value = "ID集合") @RequestParam("idList") List<String> idList) {
        try {
            this.terminalPromotersVoService.delete(idList);
            return Result.ok();
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PatchMapping("enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.terminalPromotersVoService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PatchMapping("disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.terminalPromotersVoService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id获取信息
     *
     * @param id 员工ID
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id获取信息")
    @GetMapping(value = {"/findById"})
    public Result<TerminalPromotersVo> findById(@RequestParam("id") String id) {
        try {
            TerminalPromotersVo list = this.terminalPromotersVoService.findById(id);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据id集合获取信息
     *
     * @param idList ID集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据id集合获取信息")
    @GetMapping(value = {"/findByIds"})
    public Result<List<TerminalPromotersVo>> findByIds(@RequestParam("idList") List<String> idList) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByIds(idList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据门店编码获取信息
     *
     * @param code 门店编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据门店编码获取信息")
    @GetMapping(value = {"/findByTerminalCode"})
    public Result<List<TerminalPromotersVo>> findByTerminalCode(@RequestParam("code") String code) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByTerminalCode(code);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据门店编码集合获取信息
     *
     * @param codeList 门店编码集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据门店编码集合获取信息")
    @GetMapping(value = {"/findByTerminalCodes"})
    public Result<List<TerminalPromotersVo>> findByTerminalCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByTerminalCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据员工编码获取信息
     *
     * @param code 员工编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据门店编码获取信息")
    @GetMapping(value = {"/findByEmployeeCode"})
    public Result<List<TerminalPromotersVo>> findByEmployeeCode(@RequestParam("code") String code) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByEmployeeCode(code);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据员工编码集合获取信息
     *
     * @param codeList 员工编码集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据员工编码集合获取信息")
    @GetMapping(value = {"/findByEmployeeCodes"})
    public Result<List<TerminalPromotersVo>> findByEmployeeCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByEmployeeCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据经销商编码获取信息
     *
     * @param code 经销商编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据门店编码获取信息")
    @GetMapping(value = {"/findByCustomerCode"})
    public Result<List<TerminalPromotersVo>> findByCustomerCode(@RequestParam("code") String code) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByCustomerCode(code);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据经销商编码集合获取信息
     *
     * @param codeList 经销商编码集合
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo>>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.4 23:46
     */
    @ApiOperation(value = "根据经销商编码集合获取信息")
    @GetMapping(value = {"/findByCustomerCodes"})
    public Result<List<TerminalPromotersVo>> findByCustomerCodes(@RequestParam("codeList") List<String> codeList) {
        try {
            List<TerminalPromotersVo> list = this.terminalPromotersVoService.findByCustomerCodes(codeList);
            return Result.ok(list);
        } catch (RuntimeException e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


}
