package com.biz.crm.mdm.business.promoters.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 促销人员
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 14:23
 */
@Component
public class PromotersDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_promoters_data_view";
    }

    @Override
    public String desc() {
        return "MDM 促销人员设置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*  FROM mdm_promoters t" +
                "  WHERE  t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}
