package com.biz.crm.mdm.business.promoters.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 促销人员
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 14:23
 */
@Component
public class TerminalPromotersDataViewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_terminal_promoters_data_view";
    }

    @Override
    public String desc() {
        return "MDM 门店和促销人员关系设置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT " +
                " t.*, " +
                " mt.terminal_name, " +
                " mp.name as employeeName, " +
                " mc.customer_name " +
                " FROM mdm_terminal_promoters t" +
                " left join mdm_terminal mt on mt.terminal_code = t.terminal_code " +
                " left join mdm_promoters mp on mp.employee_code = t.employee_code " +
                " left join mdm_customer mc on mc.customer_code = t.customer_code " +
                "  WHERE  t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }
}
