package com.biz.crm.mdm.business.promoters.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 促销人员实体
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 21:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(
        name = "mdm_promoters",
        indexes = {
                @Index(name = "mdm_promoters_index1", columnList = "terminal_code"),
                @Index(name = "mdm_promoters_index2", columnList = "employee_code", unique = true),
                @Index(name = "mdm_promoters_index3", columnList = "org_code"),
                @Index(name = "mdm_promoters_index4", columnList = "account"),
                @Index(name = "mdm_promoters_index5", columnList = "phone"),
        })
@TableName(value = "mdm_promoters")
@org.hibernate.annotations.Table(appliesTo = "mdm_promoters", comment = "促销人员实体类")
public class Promoters extends TenantFlagOpEntity {


    @ApiModelProperty(name = "terminalCode", notes = "门店编码")
    @TableField(value = "terminal_code")
    @Column(name = "terminal_code", columnDefinition = "varchar(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @TableField(value = "employee_code")
    @Column(name = "employee_code", nullable = false, columnDefinition = "varchar(64) COMMENT '员工号'")
    private String employeeCode;

    @ApiModelProperty(name = "orgCode", notes = "组织编码")
    @TableField(value = "org_code")
    @Column(name = "org_code", columnDefinition = "varchar(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty(name = "source", notes = "请求来源")
    @TableField(value = "source")
    @Column(name = "source", columnDefinition = "varchar(64) COMMENT '请求来源'")
    private String source;

    @ApiModelProperty(name = "roleCode", notes = "角色编码")
    @TableField(value = "role_code")
    @Column(name = "role_code", columnDefinition = "varchar(64) COMMENT '角色编码'")
    private String roleCode;

    @ApiModelProperty(name = "outZwCode", notes = "外部智网编码")
    @TableField(value = "out_zw_code")
    @Column(name = "out_zw_code", columnDefinition = "varchar(64) COMMENT '外部智网编码'")
    private String outZwCode;

    @ApiModelProperty(name = "outZwType", notes = "外部智网用户类型")
    @TableField(value = "out_zw_type")
    @Column(name = "out_zw_type", columnDefinition = "varchar(128) COMMENT '外部智网用户类型'")
    private String outZwType;

    @ApiModelProperty(name = "account", notes = "用户账号")
    @TableField(value = "account")
    @Column(name = "account", columnDefinition = "varchar(64) COMMENT '用户账号'")
    private String account;

    @ApiModelProperty(name = "phone", notes = "手机号")
    @TableField(value = "phone")
    @Column(name = "phone", columnDefinition = "varchar(11) COMMENT '手机号'")
    private String phone;

    @ApiModelProperty(name = "name", notes = "用户姓名")
    @TableField(value = "name")
    @Column(name = "name", columnDefinition = "varchar(256) COMMENT '用户姓名'")
    private String name;

    @ApiModelProperty(name = "userType", notes = "用户类型")
    @TableField(value = "user_type")
    @Column(name = "user_type", columnDefinition = "varchar(256) COMMENT '用户类型'")
    private String userType;

    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    @ApiModelProperty(name = "identityCard", notes = "身份证号")
    @TableField(value = "identity_card")
    @Column(name = "identity_card", columnDefinition = "varchar(20) COMMENT '身份证号'")
    private String identityCard;

    @ApiModelProperty(name = "password", notes = "密码")
    @TableField(value = "password")
    @Column(name = "password", columnDefinition = "varchar(64) COMMENT '密码'")
    private String password;

    @ApiModelProperty(name = "validStartDate", notes = "有效开始时间")
    @TableField(value = "valid_start_date")
    @Column(name = "valid_start_date", columnDefinition = "varchar(19) COMMENT '有效开始时间'")
    private String validStartDate;

    @ApiModelProperty(name = "validEndDate", notes = "有效结束时间")
    @TableField(value = "valid_end_date")
    @Column(name = "valid_end_date", columnDefinition = "varchar(19) COMMENT '有效结束时间'")
    private String validEndDate;

    @ApiModelProperty(name = "status", notes = "用户状态:1:启用，2:禁用 默认:启用")
    @TableField(value = "status")
    @Column(name = "status", columnDefinition = "varchar(1) COMMENT '用户状态:1:启用，2:禁用 默认:启用'")
    private Integer status;

    @ApiModelProperty(name = "authStatus", notes = "认证状态:1:已认证，0:未认证 默认:未认证")
    @TableField(value = "auth_status")
    @Column(name = "auth_status", columnDefinition = "varchar(1) COMMENT '认证状态:1:已认证，0:未认证 默认:未认证'")
    private Integer authStatus;

    @ApiModelProperty(name = "parentEmployeeCode", notes = "上级人员编码")
    @TableField(value = "parent_employee_code")
    @Column(name = "parent_employee_code", columnDefinition = "varchar(64) COMMENT '上级人员编码'")
    private String parentEmployeeCode;

    @ApiModelProperty(name = "parentEmployeeName", notes = "上级人员姓名")
    @TableField(value = "parent_employee_name")
    @Column(name = "parent_employee_name", columnDefinition = "varchar(256) COMMENT '上级人员姓名'")
    private String parentEmployeeName;

    @ApiModelProperty(name = "customerCode", notes = "客户(经销商)编码")
    @TableField(value = "customer_code")
    @Column(name = "customer_code", columnDefinition = "varchar(64) COMMENT '客户(经销商)编码'")
    private String customerCode;

    @ApiModelProperty(name = "customerName", notes = "客户(经销商)名称")
    @TableField(value = "customer_name")
    @Column(name = "customer_name", columnDefinition = "varchar(256) COMMENT '客户(经销商)名称'")
    private String customerName;

    @ApiModelProperty(name = "areaCode", notes = "地理区域")
    @TableField(value = "area_code")
    @Column(name = "area_code", columnDefinition = "varchar(64) COMMENT '地理区域'")
    private String areaCode;

    @ApiModelProperty(name = "creatorCode", notes = "双中心创建人")
    @TableField(value = "creator_code")
    @Column(name = "creator_code", columnDefinition = "varchar(64) COMMENT '双中心创建人'")
    private String creatorCode;

    @ApiModelProperty(name = "modifierCode", notes = "双中心修改人")
    @TableField(value = "modifier_code")
    @Column(name = "modifier_code", columnDefinition = "varchar(64) COMMENT '双中心修改人'")
    private String modifierCode;

    @ApiModelProperty(name = "outZwId", notes = "智网empId")
    @TableField(value = "out_zw_id")
    @Column(name = "out_zw_id", columnDefinition = "varchar(64) COMMENT '智网empId'")
    private String outZwId;

    @ApiModelProperty(name = "unionId", notes = "unionId")
    @TableField(value = "union_id")
    @Column(name = "union_id", columnDefinition = "varchar(64) COMMENT 'unionId'")
    private String unionId;

    @ApiModelProperty(name = "openId", notes = "openId")
    @TableField(value = "open_id")
    @Column(name = "open_id", columnDefinition = "varchar(64) COMMENT 'openId'")
    private String openId;

    @ApiModelProperty(name = "appId", notes = "appId")
    @TableField(value = "app_id")
    @Column(name = "app_id", columnDefinition = "varchar(64) COMMENT 'appId'")
    private String appId;

    @ApiModelProperty(name = "empId", notes = "empId")
    @TableField(value = "emp_id")
    @Column(name = "emp_id", columnDefinition = "varchar(64) COMMENT 'empId'")
    private String empId;

    @ApiModelProperty(name = "wxAuthStatus", notes = "微信认证状态")
    @TableField(value = "wx_auth_status")
    @Column(name = "wx_auth_status", columnDefinition = "varchar(32) COMMENT '微信认证状态'")
    private String wxAuthStatus;

    @ApiModelProperty(name = "identityAuthStatus", notes = "身份认证状态")
    @TableField(value = "identity_auth_status")
    @Column(name = "identity_auth_status", columnDefinition = "varchar(32) COMMENT '身份认证状态'")
    private String identityAuthStatus;

    @ApiModelProperty(name = "employeeStatus", notes = "总认证状态")
    @TableField(value = "employee_status")
    @Column(name = "employee_status", columnDefinition = "varchar(32) COMMENT '总认证状态'")
    private String employeeStatus;

    @ApiModelProperty(name = "fourIdentityCard", notes = "身份证号后四位")
    @TableField(value = "four_identity_card")
    @Column(name = "four_identity_card", columnDefinition = "varchar(8) COMMENT '身份证号后四位'")
    private String fourIdentityCard;

    @ApiModelProperty(name = "customerUserCode", notes = "客户人员编码")
    @TableField(value = "customer_user_code")
    @Column(name = "customer_user_code", columnDefinition = "varchar(32) COMMENT '客户人员编码'")
    private String customerUserCode;

    @ApiModelProperty(name = "outStoreDate", notes = "外部店仓时间")
    @TableField(value = "out_store_date")
    @Column(name = "out_store_date", columnDefinition = "varchar(19) COMMENT '外部店仓时间'")
    private String outStoreDate;

    @ApiModelProperty(name = "outCreateDate", notes = "外部创建时间")
    @TableField(value = "out_create_date")
    @Column(name = "out_create_date", columnDefinition = "varchar(19) COMMENT '外部创建时间'")
    private String outCreateDate;

    @ApiModelProperty(name = "age", notes = "年龄（岁）")
    @TableField(value = "age")
    @Column(name = "age", columnDefinition = "varchar(3) COMMENT '年龄（岁）'")
    private String age;

    @ApiModelProperty(name = "inMengNiuDate", notes = "入蒙牛时间")
    @TableField(value = "in_meng_niu_Date")
    @Column(name = "in_meng_niu_Date", columnDefinition = "varchar(19) COMMENT '入蒙牛时间'")
    private String inMengNiuDate;

    @ApiModelProperty(name = "inVerticalDate", notes = "入垂直时间")
    @TableField(value = "in_vertical_date")
    @Column(name = "in_vertical_date", columnDefinition = "varchar(19) COMMENT '入垂直时间'")
    private String inVerticalDate;

    @ApiModelProperty(name = "regularDate", notes = "转正时间")
    @TableField(value = "regular_date")
    @Column(name = "regular_date", columnDefinition = "varchar(19) COMMENT '转正时间'")
    private String regularDate;

    @ApiModelProperty(name = "quitDate", notes = "离职时间")
    @TableField(value = "quit_date")
    @Column(name = "quit_date", columnDefinition = "varchar(19) COMMENT '离职时间'")
    private String quitDate;

    @ApiModelProperty(name = "regionCode", notes = "大区编码")
    @TableField(value = "region_code")
    @Column(name = "region_code", columnDefinition = "varchar(32) COMMENT '大区编码'")
    private String regionCode;

    @ApiModelProperty(name = "regionName", notes = "大区名称")
    @TableField(value = "region_name")
    @Column(name = "region_name", columnDefinition = "varchar(32) COMMENT '大区名称'")
    private String regionName;

    @ApiModelProperty(name = "provinceCode", notes = "省份编码")
    @TableField(value = "province_code")
    @Column(name = "province_code", columnDefinition = "varchar(32) COMMENT '省份编码'")
    private String provinceCode;

    @ApiModelProperty(name = "provinceName", notes = "省份名称")
    @TableField(value = "province_name")
    @Column(name = "province_name", columnDefinition = "varchar(128) COMMENT '省份名称'")
    private String provinceName;

    @ApiModelProperty(name = "cityCode", notes = "城市编码")
    @TableField(value = "city_code")
    @Column(name = "city_code", columnDefinition = "varchar(32) COMMENT '城市编码'")
    private String cityCode;

    @ApiModelProperty(name = "cityName", notes = "城市名称")
    @TableField(value = "city_name")
    @Column(name = "city_name", columnDefinition = "varchar(128) COMMENT '城市名称'")
    private String cityName;

    @ApiModelProperty(name = "cityLevel", notes = "城市级别[数据字典:]")
    @TableField(value = "city_level")
    @Column(name = "city_level", columnDefinition = "varchar(32) COMMENT '城市级别'")
    private String cityLevel;

    @ApiModelProperty(name = "systemCode", notes = "系统编码")
    @TableField(value = "system_code")
    @Column(name = "system_code", columnDefinition = "varchar(32) COMMENT '系统编码'")
    private String systemCode;

    @ApiModelProperty(name = "systemName", notes = "系统名称")
    @TableField(value = "system_name")
    @Column(name = "system_name", columnDefinition = "varchar(128) COMMENT '系统名称'")
    private String systemName;

    @ApiModelProperty(name = "kadCode", notes = "KAD编码")
    @TableField(value = "kad_code")
    @Column(name = "kad_code", columnDefinition = "varchar(32) COMMENT 'KAD编码'")
    private String kadCode;

    @ApiModelProperty(name = "firstChannelCode", notes = "一级渠道编码")
    @TableField(value = "first_channel_code")
    @Column(name = "first_channel_code", columnDefinition = "varchar(32) COMMENT '一级渠道编码'")
    private String firstChannelCode;

    @ApiModelProperty(name = "firstChannelName", notes = "一级渠道名称")
    @TableField(value = "first_channel_name")
    @Column(name = "first_channel_name", columnDefinition = "varchar(32) COMMENT '一级渠道名称'")
    private String firstChannelName;

    @ApiModelProperty(name = "secondChannelCode", notes = "二级渠道编码")
    @TableField(value = "second_channel_code")
    @Column(name = "second_channel_code", columnDefinition = "varchar(32) COMMENT '二级渠道编码'")
    private String secondChannelCode;

    @ApiModelProperty(name = "secondChannelName", notes = "二级渠道名称")
    @TableField(value = "second_channel_name")
    @Column(name = "second_channel_name", columnDefinition = "varchar(32) COMMENT '二级渠道名称'")
    private String secondChannelName;

    @ApiModelProperty(name = "responsibleSupervision", notes = "责任督导")
    @TableField(value = "responsible_supervision")
    @Column(name = "responsible_supervision", columnDefinition = "varchar(32) COMMENT '责任督导'")
    private String responsibleSupervision;

    @ApiModelProperty(name = "responsibleBusiness", notes = "责任业务")
    @TableField(value = "responsible_business")
    @Column(name = "responsible_business", columnDefinition = "varchar(32) COMMENT '责任业务'")
    private String responsibleBusiness;

    @ApiModelProperty(name = "identityCardFrontAddress", notes = "身份证正面图地址")
    @TableField(value = "identity_card_front_address")
    @Column(name = "identity_card_front_address", columnDefinition = "varchar(128) COMMENT '身份证正面图地址'")
    private String identityCardFrontAddress;

    @ApiModelProperty(name = "identityCardBackAddress", notes = "身份证反面图地址")
    @TableField(value = "identity_card_back_address")
    @Column(name = "identity_card_back_address", columnDefinition = "varchar(128) COMMENT '身份证反面图地址'")
    private String identityCardBackAddress;
}
