package com.biz.crm.mdm.business.promoters.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 门店促销人员关系实体
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 21:57
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(
        name = "mdm_terminal_promoters",
        indexes = {
                @Index(name = "mdm_terminal_promoters_index1", columnList = "terminal_code"),
                @Index(name = "mdm_terminal_promoters_index2", columnList = "employee_code"),
                @Index(name = "mdm_terminal_promoters_index3", columnList = "unique_code", unique = true),
        })
@TableName(value = "mdm_terminal_promoters")
@org.hibernate.annotations.Table(appliesTo = "mdm_terminal_promoters", comment = "门店促销人员关系实体类")
public class TerminalPromoters extends TenantFlagOpEntity {

    private static final long serialVersionUID = -7864322342977945824L;

    @ApiModelProperty(name = "terminalCode", notes = "门店编码")
    @TableField(value = "terminal_code")
    @Column(name = "terminal_code", nullable = false, columnDefinition = "varchar(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @TableField(value = "employee_code")
    @Column(name = "employee_code", nullable = false, columnDefinition = "varchar(64) COMMENT '员工号'")
    private String employeeCode;

    @ApiModelProperty(name = "uniqueCode", notes = "唯一标记:终端编码+员工编码+经销商编码")
    @TableField(value = "unique_code")
    @Column(name = "unique_code", nullable = false, columnDefinition = "varchar(128) COMMENT '唯一标记:终端编码+员工编码+经销商编码'")
    private String uniqueCode;

    @ApiModelProperty(name = "customerCode", notes = "经销商编码")
    @TableField(value = "customer_code")
    @Column(name = "customer_code",  columnDefinition = "varchar(64) COMMENT '经销商编码'")
    private String customerCode;

    @ApiModelProperty(name = "status", notes = "状态")
    @TableField(value = "status")
    @Column(name = "status",  columnDefinition = "varchar(1) COMMENT '状态'")
    private Integer status;
}
