package com.biz.crm.mdm.business.promoters.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.promoters.local.entity.Promoters;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 促销人员信息(Promoters)表数据库访问层
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 22:30
 */
public interface PromotersMapper extends BaseMapper<Promoters> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<PromotersVo> findByConditions(Page<PromotersVo> page, @Param("dto") PromotersDto dto);

    List<PromotersVo> findSelectList(@Param("dto") PromotersSelectDto dto,@Param("limitSize") int commonSelectDefaultSize);

    List<PromotersVo> findTerminalPromoters(@Param("dto") PromotersDto dto);

    List<PromotersVo> findTerminalPromotersByTerminal(@Param("dto") PromotersDto dto);
}
