package com.biz.crm.mdm.business.promoters.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.promoters.local.entity.TerminalPromoters;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 门店促销人员关系(Promoters)表数据库访问层
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.11 14:03
 */
public interface TerminalPromotersMapper extends BaseMapper<TerminalPromoters> {

    /**
     * 分页列表
     *
     * @param page 分页信息
     * @param dto  分页参数dto
     * @return 分页列表
     */
    Page<TerminalPromotersVo> findByConditions(Page<TerminalPromotersVo> page, @Param("dto") TerminalPromotersDto dto);

    /**
     * 分页查询员工和店铺关系
     * @param page
     * @param terminalCodeList
     * @return
     */
    Page<PromotersVo> findPromotersByTerminalCodes(Page<TerminalPromotersVo> page,@Param("list") List<String> terminalCodeList);
}
