package com.biz.crm.mdm.business.promoters.local.repository;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.promoters.local.entity.Promoters;
import com.biz.crm.mdm.business.promoters.local.mapper.PromotersMapper;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collections;
import java.util.List;

/**
 * 促销人员信息(repository)
 *
 * @describe: 简述
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.4 22:53
 */
@Component
public class PromotersRepository extends ServiceImpl<PromotersMapper, Promoters> {

    /**
     * 分页
     *
     * @param page
     * @param dto
     * @return
     */
    public Page<PromotersVo> findByConditions(Page<PromotersVo> page, PromotersDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.baseMapper.findByConditions(page, dto);
    }

    /**
     * 根据id获取详情
     *
     * @param id 员工ID
     * @return
     */
    public Promoters findById(String id) {
        if (!StringUtils.hasText(id)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(Promoters::getId, id)
                .eq(Promoters::getTenantCode, TenantUtils.getTenantCode())
                .eq(Promoters::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据id集合获取详情集合
     *
     * @param idList ID集合
     * @return
     */
    public List<Promoters> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(Promoters::getId, idList)
                .eq(Promoters::getTenantCode, TenantUtils.getTenantCode())
                .eq(Promoters::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据编码获取详情
     *
     * @param code 编码
     * @return
     */
    public Promoters findByCode(String code) {
        if (!StringUtils.hasText(code)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(Promoters::getEmployeeCode, code)
                .eq(Promoters::getTenantCode, TenantUtils.getTenantCode())
                .eq(Promoters::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
    }

    /**
     * 根据编码集合获取详情集合
     *
     * @param codeList 编码集合
     * @return
     */
    public List<Promoters> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .in(Promoters::getEmployeeCode, codeList)
                .eq(Promoters::getTenantCode, TenantUtils.getTenantCode())
                .eq(Promoters::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据编码查询是否存在
     *
     * @param code 编码
     * @return
     */
    public Integer countByCode(String code) {
        if (!StringUtils.hasText(code)) {
            return 0;
        }
        return this.lambdaQuery()
                .eq(Promoters::getTenantCode, TenantUtils.getTenantCode())
                .eq(Promoters::getEmployeeCode, code)
                .count();
    }

    /**
     * 根据主键集合，修改 enable_status
     *
     * @param enable 状态
     * @param ids    ID集合
     */
    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper<Promoters> updateWrapper = new UpdateWrapper<>();
        updateWrapper.set("enable_status", enable.getCode());
        updateWrapper.in("id", ids);
        this.update(updateWrapper);
    }

    public List<PromotersVo> findSelectList(PromotersSelectDto dto, int commonSelectDefaultSize) {
        return this.baseMapper.findSelectList(dto,commonSelectDefaultSize);
    }

    public List<PromotersVo> findTerminalPromoters(PromotersDto dto) {
        return this.baseMapper.findTerminalPromoters(dto);
    }

    public List<PromotersVo> findTerminalPromotersByTerminal(PromotersDto dto) {
        return this.baseMapper.findTerminalPromotersByTerminal(dto);
    }
}
