package com.biz.crm.mdm.business.promoters.local.service.xxjob;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.concurrent.TimeUnit;


/**
 * 计算实际销量    job
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.12.15 13:39
 */
@Slf4j
@Service
public class PromotersAutoSyncXxlJob {

    @Autowired(required = false)
    private PromotersVoService promotersVoService;

    @Autowired(required = false)
    private RedisMutexService redisMutexService;

    private static final String LOCK_KEY = "PROMOTERS_AUTO_SYNC_XXL_JOB_";

    /**
     * 更新促销人员信息
     */
    @DynamicTaskService(cornExpression = "0 0 2 1 1/1 ?", taskDesc = "更新促销人员信息")
    public void actualSalesAutoSyncXxlJob() {
        //TODO  需要改成  定时任务分片+redis锁
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
        try {
            lock = this.redisMutexService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            log.info("=====>    更新促销人员信息[{}] start    <=====", DateUtil.dateStrNowAll());
            boolean loopFlag = true;
            int pageNum = 0;
            PromotersDto dto = new PromotersDto();
            while (loopFlag) {
                Pageable pageable = PageRequest.of(pageNum, 50);
                Page<PromotersVo> byConditions = this.promotersVoService.findByConditions(pageable, dto);
                if (CollectionUtils.isEmpty(byConditions.getRecords())) {
                    loopFlag = false;
                    continue;
                }
                byConditions.getRecords().forEach(o -> {
                    dto.setEmployeeCode(o.getEmployeeCode());
                    this.promotersVoService.sync(dto);
                });
                pageNum++;
            }
        }catch (Exception e){
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg(e));
        }finally {
            log.info("=====>    更新促销人员信息[{}] end    <=====", DateUtil.dateStrNowAll());
            if (lock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }
}
