/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4fc3\u9500\u4eba\u5458\u7ba1\u7406: PromotersVo: \u4fc3\u9500\u4eba\u5458"})
@RestController
@RequestMapping(value={"/v1/promoters/promotersVo"})
public class PromotersVoController {
    private static final Logger log = LoggerFactory.getLogger(PromotersVoController.class);
    @Autowired(required=false)
    private PromotersVoService promotersVoService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<PromotersVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, PromotersDto dto) {
        try {
            Page result = this.promotersVoService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"createOrUpdate"})
    public Result<List<PromotersVo>> createOrUpdate(@RequestBody List<PromotersDto> dtoList) {
        try {
            List result = this.promotersVoService.createOrUpdate(dtoList);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"create"})
    public Result<PromotersVo> create(@ApiParam(name="dto", value="\u4fc3\u9500\u4eba\u5458") @RequestBody PromotersDto dto) {
        try {
            PromotersVo result = this.promotersVoService.create(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539")
    @PatchMapping(value={"update"})
    public Result<PromotersVo> update(@ApiParam(name="dto", value="\u4fc3\u9500\u4eba\u5458") @RequestBody PromotersDto dto) {
        try {
            PromotersVo result = this.promotersVoService.update(dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"delete"})
    public Result<?> delete(@ApiParam(name="idList", value="ID\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.promotersVoService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.promotersVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.promotersVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public Result<PromotersVo> findById(@RequestParam(value="id") String id) {
        try {
            PromotersVo list = this.promotersVoService.findById(id);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/findByIds"})
    public Result<List<PromotersVo>> findByIds(@RequestParam(value="idList") List<String> idList) {
        try {
            List list = this.promotersVoService.findByIds(idList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/findByCode"})
    public Result<PromotersVo> findByCode(@RequestParam(value="code") String code) {
        try {
            PromotersVo list = this.promotersVoService.findByCode(code);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u96c6\u5408\u83b7\u53d6\u4fe1\u606f")
    @GetMapping(value={"/findByCodes"})
    public Result<List<PromotersVo>> findByCodes(@RequestParam(value="codeList") List<String> codeList) {
        try {
            List list = this.promotersVoService.findByCodes(codeList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u8eab\u4efd\u8bc1\u53f7\u96c6\u5408\u67e5\u8be2\u8be6\u60c5")
    @PostMapping(value={"/findByIdCard"})
    public Result<List<PromotersVo>> findByIdCard(@RequestBody List<String> idCardList) {
        try {
            List list = this.promotersVoService.findByIdCard(idCardList);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fc3\u9500\u4eba\u5458\u4e0b\u62c9")
    @PostMapping(value={"findSelectList"})
    public Result<List<PromotersVo>> findSelectList(@ApiParam(name="CommonSelectDto", value="\u67e5\u8be2\u53c2\u6570") @RequestBody PromotersSelectDto dto) {
        try {
            List list = this.promotersVoService.findSelectList(dto);
            return Result.ok((Object)list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u4fc3\u9500\u95e8\u5e97\u4eba\u5458")
    @PostMapping(value={"findTerminalPromoters"})
    public Result<List<PromotersVo>> findTerminalPromoters(@RequestBody PromotersDto dto) {
        try {
            return Result.ok((Object)this.promotersVoService.findTerminalPromoters(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u95e8\u5e97\u67e5\u8be2\u4fc3\u9500\u95e8\u5e97\u4eba\u5458")
    @PostMapping(value={"findTerminalPromotersByTerminal"})
    public Result<List<PromotersVo>> findTerminalPromotersByTerminal(@RequestBody PromotersDto dto) {
        try {
            return Result.ok((Object)this.promotersVoService.findTerminalPromotersByTerminal(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u540c\u6b65")
    @PostMapping(value={"sync"})
    public Result<?> sync(@RequestBody PromotersDto dto) {
        try {
            Assert.hasText((String)dto.getEmployeeCode(), (String)"\u5458\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            Page byConditions = this.promotersVoService.findByConditions(null, dto);
            byConditions.getRecords().forEach(o -> {
                dto.setEmployeeCode(o.getEmployeeCode());
                this.promotersVoService.sync(dto);
            });
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

