/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.promoters.local.entity.Promoters;
import com.biz.crm.mdm.business.promoters.local.mapper.PromotersMapper;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collections;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class PromotersRepository
extends ServiceImpl<PromotersMapper, Promoters> {
    public Page<PromotersVo> findByConditions(Page<PromotersVo> page, PromotersDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((PromotersMapper)this.baseMapper).findByConditions(page, dto);
    }

    public Promoters findById(String id) {
        if (!StringUtils.hasText((String)id)) {
            return null;
        }
        return (Promoters)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Promoters> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, idList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Promoters findByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return null;
        }
        return (Promoters)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Promoters::getEmployeeCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Promoters> findByCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Promoters::getEmployeeCode, codeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public Integer countByCode(String code) {
        if (!StringUtils.hasText((String)code)) {
            return 0;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Promoters::getEmployeeCode, (Object)code)).count();
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        this.update((Wrapper)updateWrapper);
    }

    public List<PromotersVo> findSelectList(PromotersSelectDto dto, int commonSelectDefaultSize) {
        return ((PromotersMapper)this.baseMapper).findSelectList(dto, commonSelectDefaultSize);
    }

    public List<PromotersVo> findTerminalPromoters(PromotersDto dto) {
        return ((PromotersMapper)this.baseMapper).findTerminalPromoters(dto);
    }

    public List<PromotersVo> findTerminalPromotersByTerminal(PromotersDto dto) {
        return ((PromotersMapper)this.baseMapper).findTerminalPromotersByTerminal(dto);
    }
}

