/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.promoters.local.entity.Promoters;
import com.biz.crm.mdm.business.promoters.local.repository.PromotersRepository;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersEventDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersSelectDto;
import com.biz.crm.mdm.business.promoters.sdk.event.PromotersEventListener;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mn.third.system.two.center.sdk.service.TwoCenterApiService;
import com.biz.crm.mn.third.system.two.center.sdk.vo.ExtraVo;
import com.biz.crm.mn.third.system.two.center.sdk.vo.PromotersVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PromotersVoServiceImpl
implements PromotersVoService {
    private static final Logger log = LoggerFactory.getLogger(PromotersVoServiceImpl.class);
    @Autowired(required=false)
    private PromotersRepository promotersRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private TwoCenterApiService twoCenterApiService;

    public Page<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findByConditions(Pageable pageable, PromotersDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new PromotersDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.promotersRepository.findByConditions((Page<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo>)page, dto);
    }

    public com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        Promoters promoters = this.promotersRepository.findById(id);
        if (Objects.isNull((Object)promoters)) {
            return null;
        }
        return (com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)promoters, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findByIds(List<String> idList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<Promoters> promotersList = this.promotersRepository.findByIds(idList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(promotersList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(promotersList, Promoters.class, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        Promoters entity = this.promotersRepository.findByCode(code);
        if (Objects.isNull((Object)entity)) {
            return null;
        }
        return (com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findByCodes(List<String> codeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<Promoters> entityList = this.promotersRepository.findByCodes(codeList);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, Promoters.class, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findByIdCard(List<String> idCardList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(idCardList)) {
            return Collections.emptyList();
        }
        List entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.promotersRepository.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(Promoters::getIdentityCard, idCardList)).list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)entityList, Promoters.class, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> createOrUpdate(List<PromotersDto> dtoList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        Set<String> codeSet = this.baseValAndBuild(dtoList);
        String redisKey = "mdm:lock:employee_code:";
        HashSet hasLockSet = new HashSet(codeSet.size());
        try {
            codeSet.forEach(code -> {
                boolean lock = this.redisMutexService.tryLock(redisKey + code, TimeUnit.MINUTES, 30);
                Assert.isTrue((boolean)lock, (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
                hasLockSet.add(code);
            });
            List<Promoters> oldEntityList = this.promotersRepository.findByCodes(new ArrayList<String>(codeSet));
            HashMap<String, Promoters> oldMap = new HashMap<String, Promoters>(codeSet.size());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(oldEntityList)) {
                oldEntityList.forEach(entity -> oldMap.put(entity.getEmployeeCode(), (Promoters)((Object)entity)));
            }
            List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList, PromotersDto.class, Promoters.class, HashSet.class, ArrayList.class, new String[0]);
            List<Promoters> addList = this.buildAddMap(entityList, oldMap);
            List<Promoters> updateList = this.buildUpdateMap(entityList, oldMap);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addList)) {
                this.promotersRepository.saveBatch(addList);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
                this.promotersRepository.updateBatchById(updateList);
            }
            this.saveLog(addList, updateList, oldMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(hasLockSet)) {
                hasLockSet.forEach(code -> this.redisMutexService.unlock(redisKey + code));
            }
        }
        List<Promoters> resultList = this.promotersRepository.findByCodes(new ArrayList<String>(codeSet));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(resultList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(resultList, Promoters.class, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private Set<String> baseValAndBuild(List<PromotersDto> dtoList) {
        HashSet<String> codeSet = new HashSet<String>(dtoList.size());
        dtoList.forEach(dto -> {
            this.commonValidate((PromotersDto)dto);
            String code = dto.getEmployeeCode();
            Assert.isTrue((!codeSet.contains(code) ? 1 : 0) != 0, (String)("\u5f53\u524d\u96c6\u5408\u5185\u7f16\u7801[" + code + "]\u91cd\u590d"));
            if (StringUtils.isEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getEnableStatus())) {
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            }
            dto.setTenantCode(TenantUtils.getTenantCode());
            codeSet.add(code);
        });
        return codeSet;
    }

    private void saveLog(List<Promoters> addList, List<Promoters> updateList, Map<String, Promoters> oldMap) {
        List list;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(addList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(addList, Promoters.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                PromotersEventDto eventDto = new PromotersEventDto();
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = PromotersEventListener::onCreate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(updateList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(updateList, Promoters.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                PromotersEventDto eventDto = new PromotersEventDto();
                eventDto.setOriginal((PromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)oldMap.getOrDefault(dto.getEmployeeCode(), new Promoters()), PromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = PromotersEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
    }

    private List<Promoters> buildAddMap(List<Promoters> entityList, Map<String, Promoters> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<Promoters> result = new ArrayList<Promoters>(entityList.size());
        entityList.stream().filter(k -> !oldMap.containsKey(k.getEmployeeCode())).filter(k -> Objects.isNull(oldMap.get(k.getEmployeeCode()))).forEach(result::add);
        return result;
    }

    private List<Promoters> buildUpdateMap(List<Promoters> entityList, Map<String, Promoters> oldMap) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<Promoters> result = new ArrayList<Promoters>(entityList.size());
        entityList.stream().filter(k -> oldMap.containsKey(k.getEmployeeCode())).filter(k -> Objects.nonNull(oldMap.get(k.getEmployeeCode()))).forEach(entity -> {
            Promoters oldEntity = (Promoters)((Object)((Object)oldMap.get(entity.getEmployeeCode())));
            entity.setId(oldEntity.getId());
            entity.setCreateTime(oldEntity.getCreateTime());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setCreateAccount(oldEntity.getCreateAccount());
            result.add((Promoters)((Object)entity));
        });
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo create(PromotersDto dto) {
        this.createValidate(dto);
        String code = dto.getEmployeeCode();
        String redisKey = "mdm:lock:employee_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            int count = this.promotersRepository.countByCode(code);
            Assert.isTrue((count < 1 ? 1 : 0) != 0, (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u5df2\u5b58\u5728,\u4e0d\u53ef\u65b0\u589e!"));
            Promoters entity = (Promoters)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, Promoters.class, HashSet.class, ArrayList.class, new String[0]));
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            this.promotersRepository.saveOrUpdate((Object)entity);
            PromotersEventDto eventDto = new PromotersEventDto();
            eventDto.setOriginal(null);
            eventDto.setNewest((PromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = PromotersEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
            com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo promotersVo = (com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
            return promotersVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo update(PromotersDto dto) {
        this.updateValidate(dto);
        String code = dto.getEmployeeCode();
        String redisKey = "mdm:lock:employee_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            PromotersEventDto eventDto = new PromotersEventDto();
            eventDto.setOriginal(dto);
            Promoters oldEntity = this.promotersRepository.findByCode(code);
            Assert.notNull((Object)((Object)oldEntity), (String)("\u4fc3\u9500\u4eba\u5458[" + code + "]\u4e0d\u5b58\u5728,\u7f16\u8f91\u5931\u8d25!"));
            dto.setId(oldEntity.getId());
            Promoters entity = (Promoters)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, Promoters.class, HashSet.class, ArrayList.class, new String[0]));
            this.promotersRepository.saveOrUpdate((Object)entity);
            eventDto.setNewest((PromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = PromotersEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
            com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo promotersVo = (com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
            return promotersVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!org.apache.commons.collections.CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Promoters> entityList = this.promotersRepository.findByIds(idList);
        entityList.forEach(entity -> {
            String code = entity.getEmployeeCode();
            entity.setEmployeeCode(code + entity.getId());
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.promotersRepository.updateBatchById(entityList);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, Promoters.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            PromotersEventDto eventDto = new PromotersEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = PromotersEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    private void createValidate(PromotersDto dto) {
        this.commonValidate(dto);
        dto.setId(null);
    }

    private void updateValidate(PromotersDto dto) {
        this.commonValidate(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u66f4\u65b0\u65f6\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Promoters businessUnit = this.promotersRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)businessUnit), (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)businessUnit.getEmployeeCode().equals(dto.getEmployeeCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01", (Object[])new Object[0]);
    }

    private void commonValidate(PromotersDto dto) {
        Validate.notBlank((CharSequence)dto.getEmployeeCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Promoters> entityList = this.promotersRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.promotersRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, Promoters.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            PromotersEventDto eventDto = new PromotersEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = PromotersEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Promoters> entityList = this.promotersRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.promotersRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, Promoters.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(entity -> {
            PromotersEventDto eventDto = new PromotersEventDto();
            eventDto.setOriginal(entity);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = PromotersEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, PromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findSelectList(PromotersSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return this.promotersRepository.findSelectList(dto, 50);
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findTerminalPromoters(PromotersDto dto) {
        Validate.notBlank((CharSequence)dto.getRegionCode(), (String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.promotersRepository.findTerminalPromoters(dto);
    }

    public List<com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo> findTerminalPromotersByTerminal(PromotersDto dto) {
        List<Object> voList = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dto.getTerminalCodeSet()) || StringUtils.isEmpty((CharSequence)dto.getUserType())) {
            return voList;
        }
        voList = this.promotersRepository.findTerminalPromotersByTerminal(dto);
        return voList;
    }

    public void sync(PromotersDto dto) {
        List promotersVos = this.twoCenterApiService.pullTwoCenterEmployeeData(dto.getEmployeeCode());
        if (CollectionUtils.isEmpty((Collection)promotersVos)) {
            return;
        }
        List promotersDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)promotersVos, PromotersVo.class, PromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        PromotersDto promotersDto = (PromotersDto)promotersDtoList.get(0);
        PromotersVo promotersVo = (PromotersVo)promotersVos.get(0);
        ExtraVo extra = promotersVo.getExtra();
        promotersDto.setInMengNiuDate(extra.getHireDate());
        promotersDto.setInVerticalDate(extra.getHireCzDate());
        promotersDto.setRegularDate(extra.getEmpConfireDate());
        promotersDto.setQuitDate(extra.getTerminationDate());
        promotersDto.setCityLevel(extra.getCityLevel());
        promotersDto.setResponsibleSupervision(extra.getSupervisionName());
        promotersDto.setResponsibleBusiness(extra.getBusinesserName());
        this.createOrUpdate(promotersDtoList);
    }
}

