/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.promoters.local.entity.TerminalPromoters;
import com.biz.crm.mdm.business.promoters.local.repository.TerminalPromotersRepository;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.dto.TerminalPromotersEventDto;
import com.biz.crm.mdm.business.promoters.sdk.event.TerminalPromotersEventListener;
import com.biz.crm.mdm.business.promoters.sdk.service.TerminalPromotersVoService;
import com.biz.crm.mdm.business.promoters.sdk.vo.PromotersVo;
import com.biz.crm.mdm.business.promoters.sdk.vo.TerminalPromotersVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TerminalPromotersVoServiceImpl
implements TerminalPromotersVoService {
    private static final Logger log = LoggerFactory.getLogger(TerminalPromotersVoServiceImpl.class);
    @Autowired(required=false)
    private TerminalPromotersRepository terminalPromotersRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;

    public Page<TerminalPromotersVo> findByConditions(Pageable pageable, TerminalPromotersDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new TerminalPromotersDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalPromotersRepository.findByConditions((Page<TerminalPromotersVo>)page, dto);
    }

    public TerminalPromotersVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        TerminalPromoters promoters = this.terminalPromotersRepository.findById(id);
        if (Objects.isNull((Object)promoters)) {
            return null;
        }
        return (TerminalPromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)promoters, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByIds(List<String> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        List<TerminalPromoters> promotersList = this.terminalPromotersRepository.findByIds(idList);
        if (CollectionUtils.isEmpty(promotersList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(promotersList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByTerminalCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByTerminalCode(code);
        if (Objects.isNull(entityList)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByTerminalCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByTerminalCodes(codeList);
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByEmployeeCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByEmployeeCode(code);
        if (Objects.isNull(entityList)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByEmployeeCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByEmployeeCodes(codeList);
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByCustomerCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return null;
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByCustomerCode(code);
        if (Objects.isNull(entityList)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<TerminalPromotersVo> findByCustomerCodes(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return Collections.emptyList();
        }
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByCustomerCodes(codeList);
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TerminalPromotersVo> createOrUpdate(List<TerminalPromotersDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(dtoList = this.baseValAndBuild(dtoList))) {
            return Collections.emptyList();
        }
        Set<String> codeSet = dtoList.stream().map(TerminalPromotersDto::getUniqueCode).collect(Collectors.toSet());
        String redisKey = "mdm:lock:terminal_employee_code:";
        HashSet hasLockSet = new HashSet(codeSet.size());
        try {
            codeSet.forEach(code -> {
                boolean lock = this.redisMutexService.tryLock(redisKey + code, TimeUnit.MINUTES, 30);
                Assert.isTrue((boolean)lock, (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
                hasLockSet.add(code);
            });
            List<TerminalPromoters> oldEntityList = this.terminalPromotersRepository.findByUniqueCodes(new ArrayList<String>(codeSet));
            HashMap<String, TerminalPromoters> oldMap = new HashMap<String, TerminalPromoters>(codeSet.size());
            if (CollectionUtils.isNotEmpty(oldEntityList)) {
                oldEntityList.forEach(entity -> {
                    entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    oldMap.put(entity.getUniqueCode(), (TerminalPromoters)((Object)entity));
                });
            }
            List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList(dtoList, TerminalPromotersDto.class, TerminalPromoters.class, HashSet.class, ArrayList.class, new String[0]);
            List<TerminalPromoters> addList = this.buildAddMap(entityList, oldMap);
            List<TerminalPromoters> updateList = this.buildUpdateMap(entityList, oldMap);
            if (CollectionUtils.isNotEmpty(addList)) {
                this.terminalPromotersRepository.saveBatch(addList);
            }
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.terminalPromotersRepository.updateBatchById(updateList);
            }
            this.saveLog(addList, updateList, oldMap);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(hasLockSet)) {
                hasLockSet.forEach(code -> this.redisMutexService.unlock(redisKey + code));
            }
        }
        List<TerminalPromoters> resultList = this.terminalPromotersRepository.findByUniqueCodes(new ArrayList<String>(codeSet));
        if (CollectionUtils.isEmpty(resultList)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(resultList, TerminalPromoters.class, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private List<TerminalPromotersDto> baseValAndBuild(List<TerminalPromotersDto> dtoList) {
        dtoList.forEach(this::commonValidateAndSetUniqueCode);
        String tenantCode = TenantUtils.getTenantCode();
        dtoList.forEach(dto -> {
            this.commonValidateAndSetUniqueCode((TerminalPromotersDto)dto);
            if (StringUtils.isEmpty((CharSequence)dto.getDelFlag())) {
                dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            }
            if (StringUtils.isEmpty((CharSequence)dto.getEnableStatus())) {
                dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            }
            dto.setTenantCode(tenantCode);
        });
        dtoList = dtoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<TerminalPromotersDto>(Comparator.comparing(TerminalPromotersDto::getUniqueCode))), ArrayList::new));
        return dtoList;
    }

    private void saveLog(List<TerminalPromoters> addList, List<TerminalPromoters> updateList, Map<String, TerminalPromoters> oldMap) {
        List list;
        if (CollectionUtils.isNotEmpty(addList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(addList, TerminalPromoters.class, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onCreate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            list = (List)this.nebulaToolkitService.copyCollectionByBlankList(updateList, TerminalPromoters.class, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
            list.forEach(dto -> {
                TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
                eventDto.setOriginal((TerminalPromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)oldMap.getOrDefault(dto.getEmployeeCode(), new TerminalPromoters()), TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
                eventDto.setNewest(dto);
                SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onUpdate;
                this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
            });
        }
    }

    private List<TerminalPromoters> buildAddMap(List<TerminalPromoters> entityList, Map<String, TerminalPromoters> oldMap) {
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<TerminalPromoters> result = new ArrayList<TerminalPromoters>(entityList.size());
        entityList.stream().filter(k -> !oldMap.containsKey(k.getUniqueCode())).filter(k -> Objects.isNull(oldMap.get(k.getUniqueCode()))).forEach(result::add);
        return result;
    }

    private List<TerminalPromoters> buildUpdateMap(List<TerminalPromoters> entityList, Map<String, TerminalPromoters> oldMap) {
        if (CollectionUtils.isEmpty(entityList)) {
            return Collections.emptyList();
        }
        ArrayList<TerminalPromoters> result = new ArrayList<TerminalPromoters>(entityList.size());
        entityList.stream().filter(k -> oldMap.containsKey(k.getUniqueCode())).filter(k -> Objects.nonNull(oldMap.get(k.getUniqueCode()))).forEach(entity -> {
            TerminalPromoters oldEntity = (TerminalPromoters)((Object)((Object)oldMap.get(entity.getUniqueCode())));
            entity.setId(oldEntity.getId());
            entity.setCreateTime(oldEntity.getCreateTime());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setCreateAccount(oldEntity.getCreateAccount());
            result.add((TerminalPromoters)((Object)entity));
        });
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public TerminalPromotersVo create(TerminalPromotersDto dto) {
        this.createValidateSetUniqueCode(dto);
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        String code = dto.getUniqueCode();
        String redisKey = "mdm:lock:terminal_employee_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            int count = this.terminalPromotersRepository.countByUniqueCode(code);
            Assert.isTrue((count < 1 ? 1 : 0) != 0, (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u5df2\u5b58\u5728,\u4e0d\u53ef\u65b0\u589e!"));
            TerminalPromoters entity = (TerminalPromoters)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, TerminalPromoters.class, HashSet.class, ArrayList.class, new String[0]));
            this.terminalPromotersRepository.saveOrUpdate((Object)entity);
            TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
            eventDto.setOriginal(null);
            eventDto.setNewest((TerminalPromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
            TerminalPromotersVo terminalPromotersVo = (TerminalPromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
            return terminalPromotersVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TerminalPromotersVo update(TerminalPromotersDto dto) {
        this.updateValidateSetUniqueCode(dto);
        String code = dto.getUniqueCode();
        String redisKey = "mdm:lock:terminal_employee_code:" + code;
        boolean lock = this.redisMutexService.tryLock(redisKey, TimeUnit.MINUTES, 3);
        Assert.isTrue((boolean)lock, (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u5176\u4ed6\u4eba\u5458\u6b63\u5728\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u518d\u8bd5!"));
        try {
            TerminalPromoters uniqueOldEntity = this.terminalPromotersRepository.findByUniqueCode(code);
            TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
            eventDto.setOriginal(dto);
            TerminalPromoters oldEntity = this.terminalPromotersRepository.findById(dto.getId());
            Assert.notNull((Object)((Object)oldEntity), (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u4e0d\u5b58\u5728,\u7f16\u8f91\u5931\u8d25!"));
            dto.setId(oldEntity.getId());
            if (uniqueOldEntity != null) {
                Assert.isTrue((boolean)uniqueOldEntity.getId().equals(oldEntity.getId()), (String)("\u95e8\u5e97\u4fc3\u9500\u4eba\u5458[" + code + "]\u5df2\u5b58\u5728,\u7f16\u8f91\u5931\u8d25!"));
            }
            TerminalPromoters entity = (TerminalPromoters)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, TerminalPromoters.class, HashSet.class, ArrayList.class, new String[0]));
            this.terminalPromotersRepository.saveOrUpdate((Object)entity);
            eventDto.setNewest((TerminalPromotersDto)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]));
            SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
            TerminalPromotersVo terminalPromotersVo = (TerminalPromotersVo)this.nebulaToolkitService.copyObjectByBlankList((Object)entity, TerminalPromotersVo.class, HashSet.class, ArrayList.class, new String[0]);
            return terminalPromotersVo;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisMutexService.unlock(redisKey);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByIds(idList);
        entityList.forEach(entity -> {
            String code = entity.getEmployeeCode();
            entity.setEmployeeCode(code + entity.getId());
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.terminalPromotersRepository.updateBatchById(entityList);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    private void createValidateSetUniqueCode(TerminalPromotersDto dto) {
        this.commonValidateAndSetUniqueCode(dto);
        dto.setId(null);
    }

    private void updateValidateSetUniqueCode(TerminalPromotersDto dto) {
        this.commonValidateAndSetUniqueCode(dto);
        TerminalPromoters businessUnit = this.terminalPromotersRepository.findById(dto.getId());
        Validate.notNull((Object)((Object)businessUnit), (String)"\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
    }

    private void commonValidateAndSetUniqueCode(TerminalPromotersDto dto) {
        dto.setTerminalCode(StringUtils.trimToEmpty((String)dto.getTerminalCode()));
        Validate.notBlank((CharSequence)dto.getTerminalCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setEmployeeCode(StringUtils.trimToEmpty((String)dto.getEmployeeCode()));
        Validate.notBlank((CharSequence)dto.getEmployeeCode(), (String)"\u4fc3\u9500\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setCustomerCode(StringUtils.trimToEmpty((String)dto.getCustomerCode()));
        dto.setUniqueCode(dto.getTerminalCode() + dto.getEmployeeCode() + dto.getCustomerCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u542f\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.terminalPromotersRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(dto -> {
            TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
            eventDto.setOriginal(dto);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<TerminalPromoters> entityList = this.terminalPromotersRepository.findByIds(ids);
        Validate.notEmpty(entityList, (String)"\u5f85\u7981\u7528\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664!", (Object[])new Object[0]);
        this.terminalPromotersRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        List list = (List)this.nebulaToolkitService.copyCollectionByBlankList(entityList, TerminalPromoters.class, TerminalPromotersDto.class, HashSet.class, ArrayList.class, new String[0]);
        list.forEach(entity -> {
            TerminalPromotersEventDto eventDto = new TerminalPromotersEventDto();
            eventDto.setOriginal(entity);
            eventDto.setNewest(null);
            SerializableBiConsumer & Serializable consumer = TerminalPromotersEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)eventDto, TerminalPromotersEventListener.class, (SerializableBiConsumer)consumer);
        });
    }

    public Page<PromotersVo> findPromotersByTerminalCodes(Pageable pageable, List<String> terminalCodeList) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.terminalPromotersRepository.findPromotersByTerminalCodes((Page<TerminalPromotersVo>)page, terminalCodeList);
    }
}

