/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.promoters.local.service.xxjob;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.promoters.sdk.dto.PromotersDto;
import com.biz.crm.mdm.business.promoters.sdk.service.PromotersVoService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PromotersAutoSyncXxlJob {
    private static final Logger log = LoggerFactory.getLogger(PromotersAutoSyncXxlJob.class);
    @Autowired(required=false)
    private PromotersVoService promotersVoService;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    private static final String LOCK_KEY = "PROMOTERS_AUTO_SYNC_XXL_JOB_";

    @DynamicTaskService(cornExpression="0 0 2 1 1/1 ?", taskDesc="\u66f4\u65b0\u4fc3\u9500\u4eba\u5458\u4fe1\u606f")
    public void actualSalesAutoSyncXxlJob() {
        boolean lock = true;
        String lockKey = LOCK_KEY + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        try {
            lock = this.redisMutexService.tryLock(lockKey, TimeUnit.HOURS, 12);
            if (!lock) {
                return;
            }
            log.info("=====>    \u66f4\u65b0\u4fc3\u9500\u4eba\u5458\u4fe1\u606f[{}] start    <=====", (Object)DateUtil.dateStrNowAll());
            boolean loopFlag = true;
            int pageNum = 0;
            PromotersDto dto = new PromotersDto();
            while (loopFlag) {
                PageRequest pageable = PageRequest.of((int)pageNum, (int)50);
                Page byConditions = this.promotersVoService.findByConditions((Pageable)pageable, dto);
                if (CollectionUtils.isEmpty((Collection)byConditions.getRecords())) {
                    loopFlag = false;
                    continue;
                }
                byConditions.getRecords().forEach(o -> {
                    dto.setEmployeeCode(o.getEmployeeCode());
                    this.promotersVoService.sync(dto);
                });
                ++pageNum;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionStackMsgUtil.stackMsg((Exception)e));
        }
        finally {
            log.info("=====>    \u66f4\u65b0\u4fc3\u9500\u4eba\u5458\u4fe1\u606f[{}] end    <=====", (Object)DateUtil.dateStrNowAll());
            if (lock) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }
}

