package com.biz.crm.mdm.business.promotion.material.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promotion.material.feign.feign.impl.PromotionMaterialFeignImpl;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @Description: 促销物料
 * @Author qiancheng
 * @Date 2023/1/21
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = PromotionMaterialFeignImpl.class)
public interface PromotionMaterialFeign {

    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/v1/promotionMaterial/promotionMaterial/findByConditions")
    Result<Page<PromotionMaterialVO>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "promotionMaterial", value = "促销物料管理") PromotionMaterialDto promotionMaterial);


    @ApiOperation(value = "物料下拉")
    @GetMapping("/v1/promotionMaterial/promotionMaterial/findMaterialSelectList")
    Result<Page<PromotionMaterialVO>> findMaterialSelectList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                                    @ApiParam(name = "promotionMaterial", value = "促销物料管理") PromotionMaterialDto promotionMaterial);

    @ApiOperation(value = "通过促销物料编码 查询物料详情")
    @GetMapping("/v1/promotionMaterial/promotionMaterial/findByMaterialCode")
    Result<PromotionMaterialVO> findByMaterialCode(@RequestParam("materialCode") @ApiParam(name = "materialCode", value = "促销物料编码") String materialCode);

    @ApiOperation(value = "通过主键 查询物料详情")
    @GetMapping("/v1/promotionMaterial/promotionMaterial/findById")
    Result<PromotionMaterialVO> findById(@RequestParam("id") @ApiParam(name = "id", value = "主键") String id);

    /**
     * 获取物料名称
     *
     * @param codes 促销物料编码集合
     * @return Map<String, String>
     */
    @ApiOperation(value = "获取物料名称")
    @PostMapping("/v1/promotionMaterial/promotionMaterial/findMaterialNameByCodes")
    Result<Map<String, String>> findMaterialNameByCodes(@RequestBody List<String> codes);
}
