package com.biz.crm.mdm.business.promotion.material.feign.feign.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promotion.material.feign.feign.PromotionMaterialFeign;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Description: 促销物料
 * @Author qiancheng
 * @Date 2023/1/21
 */
@Component
public class PromotionMaterialFeignImpl implements FallbackFactory<PromotionMaterialFeign> {

    @Override
    public PromotionMaterialFeign create(Throwable cause) {
        return new PromotionMaterialFeign() {
            @Override
            public Result<Page<PromotionMaterialVO>> findByConditions(Pageable pageable, PromotionMaterialDto promotionMaterial) {
                throw new UnsupportedOperationException("条件查询熔断");
            }

            @Override
            public Result<Page<PromotionMaterialVO>> findMaterialSelectList(Pageable pageable, PromotionMaterialDto promotionMaterial) {
                throw new UnsupportedOperationException("条件查询熔断");
            }

            @Override
            public Result<PromotionMaterialVO> findByMaterialCode(String materialCode) {
                throw new UnsupportedOperationException("条件查询熔断");
            }

            @Override
            public Result<PromotionMaterialVO> findById(String id) {
                throw new UnsupportedOperationException("条件查询熔断");
            }

            @Override
            public Result<Map<String, String>> findMaterialNameByCodes(List<String> codes) {
                throw new UnsupportedOperationException("获取物料名称熔断");
            }
        };
    }
}
