package com.biz.crm.mdm.business.promotion.material.feign.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.promotion.material.feign.feign.PromotionMaterialFeign;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.OrderQualityLevelDto;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.OrderQualityLevelVO;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Map;

/**
 * @Description: 促销物料
 * @Author qiancheng
 * @Date 2023/1/21
 */
@Service
public class PromotionMaterialVoServiceImpl implements PromotionMaterialService {

    @Autowired(required = false)
    private PromotionMaterialFeign promotionMaterialFeign;

    @Override
    public Page<PromotionMaterialVO> findByConditions(Pageable pageable, PromotionMaterialDto promotionMaterial) {
        Result<Page<PromotionMaterialVO>> page = promotionMaterialFeign.findByConditions(pageable, promotionMaterial);
        if(page.isSuccess()){
            return page.getResult();
        }else {
            return new Page<>();
        }
    }

    @Override
    public PromotionMaterialVO findByIdOrMaterialCode(String id, String materialCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void create(PromotionMaterialDto promotionMaterial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(PromotionMaterialDto promotionMaterial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateEnableStatus(List<String> ids, String enableStatus) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void importSave(List<PromotionMaterialDto> importList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Page<PromotionMaterialVO> findMaterialSelectList(Pageable pageable, PromotionMaterialDto promotionMaterial) {
        Result<Page<PromotionMaterialVO>> page = promotionMaterialFeign.findMaterialSelectList(pageable, promotionMaterial);
        if(page.isSuccess()){
            return page.getResult();
        }else {
            return new Page<>();
        }
    }

    /**
     * 根据物料编码&数量找单价
     * feign未实现，禁止调用
     *
     * @param dto
     * @return
     */
    @Override
    public OrderQualityLevelVO findPriceByMaterialCode(OrderQualityLevelDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> findMaterialNameByCodes(List<String> codes) {
        Result<Map<String, String>> listResult = promotionMaterialFeign.findMaterialNameByCodes(codes);
        Assert.isTrue(listResult.isSuccess(), listResult.getMessage());
        return listResult.getResult();
    }
}
