package com.biz.crm.mdm.business.promotion.material.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  促销物料管理 DataView
 *  * @author qiancheng
 *  * @since 2022-11-24
 */
@Component
public class PromotionMaterialDataView implements DataviewRegister {

    @Override
    public String code() {
        return "mdm_promotion_material";
    }

    @Override
    public String desc() {
        return "MDM-促销物料管理";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM mdm_promotion_material t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }
}
