package com.biz.crm.mdm.business.promotion.material.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 实体: 订单数量坎级
 *
 * @author: qiancheng
 * @date: 2022-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_order_quality_level")
@ApiModel(value = "OrderQualityLevel", description = "订单数量坎级")
@Table(
        name = "mdm_order_quality_level",
        indexes = {
                @Index(name = "mdm_quality_level_index1", unique = false, columnList = "material_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_order_quality_level", comment = "订单数量坎级")
public class OrderQualityLevel extends TenantFlagOpEntity {

    @TableField(value = "material_code")
    @Column(name = "material_code", nullable = false,length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
    private String materialCode;

    @TableField(value = "quality_one")
    @Column(name = "quality_one", nullable = true, columnDefinition = "int COMMENT '数量1'")
    private Integer qualityOne;

    @TableField(value = "symbol_one")
    @Column(name = "symbol_one", nullable = true, length = 32, columnDefinition = "VARCHAR(255) COMMENT '符号1'")
    private String symbolOne;

    @TableField(value = "symbol_two")
    @Column(name = "symbol_two", nullable = true, length = 32, columnDefinition = "VARCHAR(255) COMMENT '符号2'")
    private String symbolTwo;

    @TableField(value = "quality_two")
    @Column(name = "quality_two", nullable = true, columnDefinition = "int COMMENT '数量2'")
    private Integer qualityTwo;

    @TableField(value = "money")
    @Column(name = "money", nullable = true,length = 24, columnDefinition = "DECIMAL(24,6) COMMENT '元'")
    private BigDecimal money;

}
