package com.biz.crm.mdm.business.promotion.material.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 实体: 促销物料管理
 *
 * @author: qiancheng
 * @date: 2022-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_promotion_material")
@ApiModel(value = "PromotionMaterial", description = "促销物料管理")
@Table(
        name = "mdm_promotion_material",
        indexes = {
                @Index(name = "mdm_promotion_material_index1", unique = false, columnList = "tenant_code,material_code"),
        })
@org.hibernate.annotations.Table(appliesTo = "mdm_promotion_material", comment = "促销物料管理")
public class PromotionMaterial extends TenantFlagOpEntity {

    @TableField(value = "material_code")
    @Column(name = "material_code", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
    private String materialCode;

    @TableField(value = "material_name")
    @Column(name = "material_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '物料名称'")
    private String materialName;

    @TableField(value = "material_type")
    @Column(name = "material_type", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '物料类别'")
    private String materialType;

    @TableField(value = "material_type_code")
    @Column(name = "material_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料类别编码'")
    private String materialTypeCode;

    @TableField(value = "package_quantity_min")
    @Column(name = "package_quantity_min", nullable = true, columnDefinition = "int COMMENT '最小包装量'")
    private Integer packageQuantityMin;

    @TableField(value = "quality_standard")
    @Column(name = "quality_standard", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '质量标准'")
    private String qualityStandard;

    @TableField(value = "box_specification")
    @Column(name = "box_specification", nullable = true, columnDefinition = "int COMMENT '箱规'")
    private Integer boxSpecification;

    @TableField(value = "material_specification")
    @Column(name = "material_specification", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '物料规格'")
    private String materialSpecification;

    @TableField(value = "unit")
    @Column(name = "unit", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '单位'")
    private String unit;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "begin_date", nullable = true,length = 20, columnDefinition = "datetime COMMENT '开始日期'")
    private Date beginDate;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "end_date", nullable = true,length = 20, columnDefinition = "datetime COMMENT '结束日期'")
    private Date endDate;

    @TableField(value = "sales_institution_code")
    @Column(name = "sales_institution_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @TableField(value = "sales_institution_name")
    @Column(name = "sales_institution_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @TableField(value = "supplier_code")
    @Column(name = "supplier_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '供应商编码'")
    private String supplierCode;

    @TableField(value = "supplier_name")
    @Column(name = "supplier_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '供应商名称'")
    private String supplierName;

    @TableField(value = "contract_code")
    @Column(name = "contract_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '关联合同编码'")
    private String contractCode;

    @TableField(value = "contract_name")
    @Column(name = "contract_name", nullable = true, length = 255, columnDefinition = "VARCHAR(255) COMMENT '关联合同名称'")
    private String contractName;



}
