package com.biz.crm.mdm.business.promotion.material.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.FileEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.ibatis.type.JdbcType;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 实体: 促销物料图片
 *
 * @author: qiancheng
 * @date: 2022-11-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_promotion_material_image")
@ApiModel(value = "PromotionMaterialImage", description = "促销物料图片")
@org.hibernate.annotations.Table(appliesTo = "mdm_promotion_material_image", comment = "促销物料图片")
@Table(name = "mdm_promotion_material_image", indexes = {@Index(name = "mdm_promotion_material_image_index1", columnList = "material_code", unique = false)})
public class PromotionMaterialImage extends FileEntity {

    @TableField(value = "material_code")
    @Column(name = "material_code", nullable = false,length = 32, columnDefinition = "VARCHAR(32) COMMENT '物料编码'")
    private String materialCode;


    @TableField(
            fill = FieldFill.INSERT,
            updateStrategy = FieldStrategy.NOT_EMPTY,
            jdbcType = JdbcType.VARCHAR
    )
    @Column(
            name = "del_flag",
            nullable = true,
            length = 10,
            columnDefinition = "varchar(10) COMMENT '数据状态（删除状态）'"
    )
    private String delFlag;

}
