package com.biz.crm.mdm.business.promotion.material.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.promotion.material.local.entity.PromotionMaterial;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import org.apache.ibatis.annotations.Param;

/**
 * 促销物料管理(mdm_promotion_material)表 数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-22
 */
public interface PromotionMaterialMapper extends BaseMapper<PromotionMaterial> {
    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param promotionMaterial 实体对象
     * @return 分页对象列表
     */
    Page<PromotionMaterialVO> findByConditions(@Param("page") Page<PromotionMaterialVO> page, @Param("dto") PromotionMaterialDto promotionMaterial);

    /**
     * 物料下拉
     *
     * @param page        分页对象
     * @param promotionMaterial 查询dto
     * @return 分页对象
     */
    Page<PromotionMaterialVO> findMaterialSelectList(@Param("page") Page<PromotionMaterialVO> page, @Param("dto") PromotionMaterialDto promotionMaterial);
}
