package com.biz.crm.mdm.business.promotion.material.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.promotion.material.local.entity.OrderQualityLevel;
import com.biz.crm.mdm.business.promotion.material.local.entity.PromotionMaterialImage;
import com.biz.crm.mdm.business.promotion.material.local.mapper.OrderQualityLevelMapper;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialImageDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.OrderQualityLevelVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/**
 * 订单数量坎级(mdm_order_quality_level)表 数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-23
 */
@Component
public class OrderQualityLevelRepository extends ServiceImpl<OrderQualityLevelMapper, OrderQualityLevel> {

    @Autowired
    private OrderQualityLevelMapper orderQualityLevelMapper;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    /**
     *  通过促销物料编码 查询订单数量坎级
     * @param materialCode 促销物料编码
     * @return 订单数量坎级集合
     */
    public List<OrderQualityLevelVO> findByMaterialCode(String materialCode) {
        QueryWrapper<OrderQualityLevel> wrapper = new QueryWrapper();
        wrapper.eq("material_code",materialCode);
        wrapper.eq("del_flag", DelFlagStatusEnum.NORMAL.getCode());
        List<OrderQualityLevel> levelEntityList = orderQualityLevelMapper.selectList(wrapper);
        return (List<OrderQualityLevelVO>) nebulaToolkitService.copyCollectionByWhiteList(levelEntityList, OrderQualityLevel.class, OrderQualityLevelVO.class, HashSet.class, ArrayList.class);
    }
}
