package com.biz.crm.mdm.business.promotion.material.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.promotion.material.local.entity.PromotionMaterial;
import com.biz.crm.mdm.business.promotion.material.local.mapper.PromotionMaterialMapper;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

/**
 * 促销物料管理(mdm_promotion_material)表 数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-22
 */
@Component
public class PromotionMaterialRepository extends ServiceImpl<PromotionMaterialMapper, PromotionMaterial> {

    @Autowired
    private PromotionMaterialMapper promotionMaterialMapper;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param promotionMaterial 实体对象
     * @return 分页对象列表
     */
    public Page<PromotionMaterialVO> findByConditions(Pageable pageable, PromotionMaterialDto promotionMaterial){
        if(pageable == null){
            pageable = PageRequest.of(0,20);
        }
        Page<PromotionMaterialVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.promotionMaterialMapper.findByConditions(page,promotionMaterial);
    }

    /**
     * 物料下拉
     *
     * @param pageable        分页对象
     * @param promotionMaterial 查询dto
     * @return 分页对象
     */
    public Page<PromotionMaterialVO> findMaterialSelectList(Pageable pageable, PromotionMaterialDto promotionMaterial) {
        if(pageable == null){
            pageable = PageRequest.of(0,50);
        }
        Page<PromotionMaterialVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.promotionMaterialMapper.findMaterialSelectList(page,promotionMaterial);

    }
}
