package com.biz.crm.mdm.business.promotion.material.local.service;

import com.biz.crm.mdm.business.promotion.material.sdk.dto.OrderQualityLevelDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.OrderQualityLevelVO;

import java.util.Collection;
import java.util.List;

/**
 *
 * @author : qiancheng
 * @date : 2022-11-22
 */
public interface OrderQualityLevelService {

    /**
     * 新增订单数量坎级
     * @param material 促销物料编码
     * @param orderQualityLevelList 实体对象集合
     */
    void create(String material,List<OrderQualityLevelDto> orderQualityLevelList);

    /**
     * 通过促销物料编码 查询订单数量坎级
     * @param MaterialCode 促销物料编码
     * @return 坎级集合
     */
    List<OrderQualityLevelVO> findByMaterialCode(String MaterialCode);

    /**
     * 通过促销物料编码 删除数据
     * @param materialCodes 促销物料编码集合
     */
    void deleteByMaterialCode(List<String> materialCodes);

    /**
     * 通过订单数量坎级集合 删除订单数量坎级
     * @param materialCode 物料编码
     * @param ids 订单数量坎级集合
     */
    void delete(String materialCode,Collection<String> ids);

    /**
     * 新赠/修改 订单数量坎级
     * @param levelList 订单数量坎级集合
     */
    void saveOrUpdate(List<OrderQualityLevelDto> levelList);
}
