package com.biz.crm.mdm.business.promotion.material.local.service;

import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialImageDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialImageVO;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;

/**
 *
 * @author : qiancheng
 * @date : 2022-11-22
 */
public interface PromotionMaterialImageService {

    /**
     * 新增 物料图片
     * @param materialCode 促销物料编码
     * @param promotionMaterialImage 实体对象
     */
    void create(String materialCode,List<PromotionMaterialImageDto> promotionMaterialImage);

    /**
     * 通过促销物料编码 查询 图片
     * @param materialCode
     * @return
     */
    List<PromotionMaterialImageVO> findByMaterialCode(String materialCode);

    /**
     * 通过促销物料编码 删除图片
     * @param materialCodes 促销物料编码集合
     */
    void deleteByMaterialCode(List<String> materialCodes);

    /**
     * 通过文件唯一识别号 删除图片
     * @param materialCode 物料编码
     * @param fileCodes
     */
    void deleteByFileCode(String materialCode,Collection<String> fileCodes);


    /**
     * 新增/修改 图片
     * @param materialImageList 图片实体集合
     */
    void saveOrUpdate(List<PromotionMaterialImageDto> materialImageList);

}
