package com.biz.crm.mdm.business.promotion.material.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.promotion.material.local.constant.PromotionMaterialConstant;
import com.biz.crm.mdm.business.promotion.material.local.entity.PromotionMaterialImage;
import com.biz.crm.mdm.business.promotion.material.local.repository.PromotionMaterialImageRepository;
import com.biz.crm.mdm.business.promotion.material.local.service.PromotionMaterialImageService;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialImageDto;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialImageVO;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 促销物料图片(mdm_promotion_material_image)表  服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-22
 */
@Slf4j
@Service("promotionMaterialImageService")
public class PromotionMaterialImageServiceImpl implements PromotionMaterialImageService {

    @Autowired
    private PromotionMaterialImageRepository promotionMaterialImageRepository;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    /**
     * 新增 物料图片
     * @param materialCode 促销物料编码
     * @param promotionMaterialImage 实体对象
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(String materialCode,List<PromotionMaterialImageDto> promotionMaterialImage) {
        if(!CollectionUtils.isEmpty(promotionMaterialImage) && !StringUtils.isBlank(materialCode)){
            promotionMaterialImage.forEach(imageDto ->{
                imageDto.setMaterialCode(materialCode);
                imageDto.setTenantCode(TenantUtils.getTenantCode());
                imageDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
            Collection<PromotionMaterialImage> promotionMaterialImages = nebulaToolkitService.copyCollectionByWhiteList(promotionMaterialImage, PromotionMaterialImageDto.class, PromotionMaterialImage.class, HashSet.class, ArrayList.class);
            promotionMaterialImageRepository.saveBatch(promotionMaterialImages);
        }
    }

    /**
     * 通过促销物料编码 查询 图片
     * @param materialCode
     * @return
     */
    @Override
    public List<PromotionMaterialImageVO> findByMaterialCode(String materialCode) {
        if(!StringUtils.isBlank(materialCode)){
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq("material_code",materialCode);
            wrapper.eq("del_flag",DelFlagStatusEnum.NORMAL.getCode());
            List<PromotionMaterialImageVO> imageVoList = promotionMaterialImageRepository.list(wrapper);
            return imageVoList;
        }
        return null;
    }

    /**
     * 通过促销物料编码集合 删除图片
     * @param materialCodes 促销物料编码集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByMaterialCode(List<String> materialCodes) {
        if(CollectionUtils.isEmpty(materialCodes)){
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set("del_flag",DelFlagStatusEnum.DELETE.getCode());
            wrapper.eq("tenant_code",TenantUtils.getTenantCode());
            wrapper.in("material_code",materialCodes);
            promotionMaterialImageRepository.update(wrapper);
        }
    }

    /**
     * 通过文件唯一识别号 删除图片
     * @param materialCode 物料编码
     * @param fileCodes 文件唯一识别号集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByFileCode(String materialCode,Collection<String> fileCodes) {
        if(!CollectionUtils.isEmpty(fileCodes)){
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.set("del_flag",DelFlagStatusEnum.DELETE.getCode());
            wrapper.eq("tenant_code",TenantUtils.getTenantCode());
            wrapper.eq("material_code",materialCode);
            wrapper.notIn("file_code",fileCodes);
            promotionMaterialImageRepository.update(wrapper);
        }
    }

    /**
     * 新增/修改 图片
     * @param materialImageList 图片实体集合
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveOrUpdate(List<PromotionMaterialImageDto> materialImageList) {
        if(!CollectionUtils.isEmpty(materialImageList)){
            Collection<PromotionMaterialImage> images = nebulaToolkitService.copyCollectionByWhiteList(materialImageList, PromotionMaterialImageDto.class, PromotionMaterialImage.class, HashSet.class, ArrayList.class);
            promotionMaterialImageRepository.saveOrUpdateBatch(images);
        }
    }


}
