package com.biz.crm.mdm.business.promotion.material.local.service.process;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.promotion.material.local.constant.PromotionMaterialConstant;
import com.biz.crm.mdm.business.promotion.material.sdk.dto.PromotionMaterialDto;
import com.biz.crm.mdm.business.promotion.material.sdk.service.PromotionMaterialService;
import com.biz.crm.mdm.business.promotion.material.sdk.vo.PromotionMaterialImportsVO;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author qiancheng
 * @date 2022-11-23
 */
@Slf4j
@Component
public class PromotionMaterialProcess implements ImportProcess<PromotionMaterialImportsVO> {

    @Autowired(required = false)
    private PromotionMaterialService promotionMaterialService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    private Map<String, String> materialTypeMap = new HashMap<>();
    private Map<String, String> materialUnitMap = new HashMap<>();

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, PromotionMaterialImportsVO> data,
                                        TaskGlobalParamsVo paramsVo, Map<String, Object> params) {

        Validate.notEmpty(data, "导入数据不能为空！");
        List<PromotionMaterialImportsVO> importsVos = new ArrayList<>(data.values());
        //更据物料名称去重
        List<PromotionMaterialImportsVO> importsVoList = importsVos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(o -> o.getMaterialName()))), ArrayList::new));

        List<PromotionMaterialDto> importList = this.validate(importsVoList);

        promotionMaterialService.importSave(importList);
        return null;
    }

    /**
     * 校验并转换数据
     * @param importsVoList 导入实体对象集合
     * @return List<PromotionMaterialDto> 实体对象集合
     */
    private List<PromotionMaterialDto> validate(List<PromotionMaterialImportsVO> importsVoList) {

        //物料类别编码
        Map<String, String> materialTypeMap = dictToolkitService.findConvertMapByDictTypeCode(PromotionMaterialConstant.MATERIAL_TYPE_DICT_CODE);
        //单位
        Map<String, String> materialUnitMap = dictToolkitService.findConvertMapByDictTypeCode(PromotionMaterialConstant.MATERIAL_UNIT_DICT_CODE);
        //查询销售机构编码...

        importsVoList.forEach(importsVo -> {
            // 校验基础数据
            this.buildData(importsVo,materialTypeMap,materialUnitMap);

        });
        List<PromotionMaterialDto> dayPriceMonitorDtoList =
                (List<PromotionMaterialDto>) nebulaToolkitService.copyCollectionByWhiteList(importsVoList, PromotionMaterialImportsVO.class, PromotionMaterialDto.class, LinkedHashSet.class, ArrayList.class);
        return dayPriceMonitorDtoList;
    }

    /**
     * 校验基础数据
     * @param vo
     * @param materialTypeMap 物料类别编码集合
     * @param materialUnitMap 单位编码集合
     */
    private void buildData(PromotionMaterialImportsVO vo, Map<String, String> materialTypeMap, Map<String, String> materialUnitMap) {
        Validate.notNull(vo,"导入数据不能为空！");
        Validate.notBlank(vo.getMaterialName(),"物料名称不能为空！");
        Validate.notBlank(vo.getMaterialSpecification(),vo.getMaterialName() + "的‘物料规格’不能为空！");
        Validate.notBlank(vo.getSalesInstitutionName(),vo.getMaterialName() + "的‘销售机构名称’不能为空！");
        //Validate.notBlank(vo.getSalesInstitutionCode(),vo.getMaterialName() + "的‘销售机构编码’不能为空！");

        //物料类别名称、类别编码
        Validate.notBlank(vo.getMaterialType(),vo.getMaterialName() + "的‘物料类别名称’不能为空！");
        if (this.materialTypeMap.containsKey(vo.getMaterialName().trim())) {
            vo.setMaterialTypeCode(this.materialTypeMap.get(vo.getMaterialName().trim()));
        }else {
            throw new RuntimeException(vo.getMaterialName() + "的‘物料类别’ 不存在！");
        }
        //最小包装量
        Validate.notBlank(vo.getPackageQuantityMinStr(),vo.getMaterialName() + "的‘最小包装量’不能为空！");
        if(!StringUtils.isBlank(vo.getPackageQuantityMinStr())){
            try {
                vo.setPackageQuantityMin(new Integer(vo.getPackageQuantityMinStr()));
            } catch (Exception e){
                throw new RuntimeException(vo.getMaterialName() + "的‘最小包装量：" + vo.getPackageQuantityMinStr() + "‘ 格式错误，请检查！");
            }
        }
        //箱规
        Validate.notBlank(vo.getBoxSpecificationStr(),vo.getMaterialName() + "的‘箱规’不能为空！");
        try {
            vo.setBoxSpecification(new Integer(vo.getBoxSpecificationStr()));
        } catch (Exception e){
            throw new RuntimeException(vo.getMaterialName() + "的’箱规：" + vo.getBoxSpecificationStr() + "‘ 格式错误，请检查！");
        }
        //单位
        Validate.notBlank(vo.getUnit(),vo.getMaterialName() + "的‘单位’不能为空！");
        if (this.materialUnitMap.containsKey(vo.getUnit().trim())) {
            vo.setUnit(this.materialUnitMap.get(vo.getUnit().trim()));
        }else {
            throw new RuntimeException(vo.getMaterialName() + "的‘单位’ 不存在！");
        }
        //有效期
        Validate.notBlank(vo.getExpirationDate(),vo.getMaterialName() + "的‘有效期’不能为空！");
        try {
            vo.setEndDate(DateUtil.parseDate(vo.getExpirationDate(), DateUtil.DEFAULT_YEAR_MONTH_DAY));
        } catch (Exception e) {
            throw new RuntimeException(vo.getMaterialName() +"的'有效期' 格式错误，应该为" + "yyyy-MM-dd");
        };

    }


    @Override
    public Class<PromotionMaterialImportsVO> findCrmExcelVoClass() {
        return PromotionMaterialImportsVO.class;
    }

    @Override
    public String getBusinessCode() {
        return "MDM_PROMOTION_MATERIAL_IMPORT";
    }

    @Override
    public String getBusinessName() {
        return "MDM促销物料管理导入";
    }

    @Override
    public String getTemplateCode() {
        return "MDM_PROMOTION_MATERIAL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "MDM-促销物料管理导入";
    }
}
