package com.biz.crm.mdm.business.region.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.region.feign.feign.impl.RegionFeignImpl;
import com.biz.crm.mdm.business.region.sdk.vo.RegionVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.swing.plaf.synth.Region;
import java.util.List;

/**
 * @ClassName RegionFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/11
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = RegionFeignImpl.class)
public interface RegionFeign {

    /**
     * 根据行政区域等级，名称获取行政区域信息
     * @param regionLevel 行政区域等级
	 * @param regionName 行政区域名称
     * @author jiangyin
     * @date 2023/2/11 16:38
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List<javax.swing.plaf.synth.Region>>
     */
    @ApiOperation("根据行政区域等级，名称获取行政区域信息")
    @GetMapping("/v1/region/region/findByRegionLevel")
    Result<List<RegionVo>> findByRegionLevel(@RequestParam(value = "regionLevel", required = false) String regionLevel,
                                             @RequestParam(value = "regionName", required = false) String regionName);

}
