package com.biz.crm.mdm.business.region.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author sunx
 * @date 2021/10/8
 */
public interface RegionMapper extends BaseMapper<Region> {

  /**
   * 根据父级编码获取子级
   *
   * @param parentCode
   * @param regionName
   * @return
   */
  List<Region> findByParentCodeAndRegionNameLike(
      @Param("parentCode") String parentCode, @Param("regionName") String regionName);

  /**
   * 分页信息
   *
   * @param page
   * @param regionPaginationDto
   * @return
   */
  Page<Region> findByConditions(
      Page<Region> page, @Param("dto") RegionPaginationDto regionPaginationDto);

  /**
   * 根据行政区域名称模糊查询，返回对应层级的降维码
   *
   * @param levelNum
   * @param ruleCodeList
   * @param regionName
   * @return
   */
  List<String> findRuleCodeListByParams(
      @Param("levelNum") Integer levelNum,
      @Param("list") List<String> ruleCodeList,
      @Param("regionName") String regionName);

  /**
   * 通过规则编码 单边模糊 （0001%）
   * 查询全部关联的行政区域以及下级区域
   *
   * @param ruleCode
   * @return
   */
  List<Region> findSelfAndLowerByRuleCode(@Param("code")String ruleCode);
}
