package com.biz.crm.mdm.business.region.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 行政区域接口
 *
 * @author sunx
 * @date 2021/10/9
 */
public interface RegionService {

  /**
   * 行政区域分页信息
   *
   * @param pageable
   * @param regionPaginationDto
   * @return
   */
  Page<Region> findByConditions(Pageable pageable, RegionPaginationDto regionPaginationDto);

  /**
   * 根据行政区域id或编码获取详情
   *
   * @param id
   * @param regionCode
   * @return
   */
  Region findDetailByIdOrCode(String id, String regionCode);

  /**
   * 新增行政区域
   *
   * @param region
   * @return
   */
  Region create(Region region);

  /**
   * 编辑行政区域
   *
   * @param region
   * @return
   */
  Region update(Region region);

  /**
   * 删除
   *
   * @param ids
   */
  void delete(List<String> ids);

  /**
   * 启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 行政区域下拉
   *
   * @param parentCode
   * @param regionName
   * @return
   */
  List<Region> findRegionSelect(String parentCode, String regionName);

  /**
   * 通过行政区域编码集合查询
   * @param regionCodeList
   * @return
   */
  List<Region> findDetailByCodes(List<String> regionCodeList);

  /**
   * 通过规则编码查询关联的行政区域以及全部下级
   * @param ruleCode
   * @return
   */
  List<Region> findSelfAndLowerByRuleCode(String ruleCode);
}
