package com.biz.crm.mdm.business.region.local.service.internal;

import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * region模块sdk实现
 *
 * @author sunx
 * @date 2021/10/9
 */
@Service("regionVoService")
public class RegionVoServiceImpl implements RegionVoService {

  @Autowired(required = false) private RegionRepository regionRepository;

  /**
   * 获取regionCode对应的regionName的map
   *
   * <p>key->regionCode,value->regionName
   *
   * @param regionCodeList
   * @return
   */
  @Override
  public Map<String, String> findRegionCodeNameMap(List<String> regionCodeList) {
    List<Region> list = regionRepository.findByRegionCodes(regionCodeList);
    if (CollectionUtils.isEmpty(list)) {
      return Maps.newHashMap();
    }
    return list.stream()
        .collect(Collectors.toMap(Region::getRegionCode, Region::getRegionName, (a, b) -> a));
  }

  @Override
  public String findRegionCode(String regionName, String parentCode) {
    Region region = this.regionRepository.findByParentCodeAndRegionName(parentCode, regionName);
    if (Objects.isNull(region)) {
      return null;
    }
    return region.getRegionCode();
  }
}
