/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.entity.RegionLabel;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.local.service.RegionLabelService;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import com.biz.crm.mdm.business.region.sdk.constant.RegionConstant;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import com.biz.crm.mdm.business.region.sdk.event.RegionEventListener;
import com.biz.crm.mdm.business.region.sdk.vo.RegionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="regionService")
public class RegionServiceImpl
implements RegionService {
    @Autowired(required=false)
    private RegionRepository regionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<RegionEventListener> regionEventListenerList;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired
    private RegionLabelService regionLabelService;

    @Override
    public Page<Region> findByConditions(Pageable pageable, RegionPaginationDto regionPaginationDto) {
        Region region;
        regionPaginationDto = Optional.ofNullable(regionPaginationDto).orElse(new RegionPaginationDto());
        regionPaginationDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Validate.isTrue((boolean)(StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionCode()) ? true : regionPaginationDto.getRegionCode().length() < 64), (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u641c\u7d22\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((boolean)(StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionName()) ? true : regionPaginationDto.getRegionName().length() < 128), (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u641c\u7d22\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Integer levelNum = 1;
        String ruleCode = "";
        if (StringUtils.isNotBlank((CharSequence)regionPaginationDto.getRegionCode()) && Objects.nonNull((Object)(region = this.regionRepository.findByRegionCode(regionPaginationDto.getRegionCode())))) {
            levelNum = region.getLevelNum() + 1;
            ruleCode = region.getRuleCode();
        }
        levelNum = Integer.min(levelNum, 5);
        List<String> ruleCodeList = this.regionRepository.findRuleCodeListByParams(levelNum, Lists.newArrayList((Object[])new String[]{ruleCode}), regionPaginationDto.getRegionName());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)regionPaginationDto.getLabelList())) {
            List labelList = regionPaginationDto.getLabelList();
            List<String> ruleCodeByLabelList = this.regionLabelService.findRuleCodeByLabelList(labelList);
            Integer length = 3 * levelNum;
            List collect = ruleCodeByLabelList.stream().filter(e -> e.length() >= length).collect(Collectors.toList());
            ArrayList<String> newRuleCodeByLabelList = new ArrayList<String>();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect)) {
                for (String code : collect) {
                    code = code.substring(0, 3 * levelNum);
                    newRuleCodeByLabelList.add(code);
                }
            }
            ruleCodeList.retainAll(newRuleCodeByLabelList);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ruleCodeList)) {
            return this.getPageRegionByList(null);
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ruleCodeList = ruleCodeList.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            return this.getPageRegionByList(null);
        }
        List<Region> list = this.regionRepository.findByRuleCods(ruleCodeList);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
            list = this.selectLabel(list);
            for (Region region2 : list) {
                region2.setHasChild(true);
                if (levelNum != 5) continue;
                region2.setHasChild(false);
            }
        }
        return this.getPageRegionByList(list);
    }

    private List<Region> selectLabel(List<Region> list) {
        List<String> regionCodes = list.stream().map(Region::getRegionCode).collect(Collectors.toList());
        List<RegionLabel> regionLabels = this.regionLabelService.findByRegionCodes(regionCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(regionLabels)) {
            return list;
        }
        Map<String, List<RegionLabel>> map = regionLabels.stream().collect(Collectors.groupingBy(RegionLabel::getRegionCode));
        for (Region region : list) {
            region.setLableList(map.get(region.getRegionCode()));
        }
        return list;
    }

    @Override
    public Region findDetailByIdOrCode(String id, String regionCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)regionCode)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.regionRepository.findById(id);
        }
        return this.regionRepository.findByRegionCode(regionCode);
    }

    @Override
    @Transactional
    public Region create(Region region) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionCode()), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionName()), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionCode().length() < 64 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionName().length() < 128 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Region cur = this.regionRepository.findByRegionCode(region.getRegionCode());
        Validate.isTrue((boolean)Objects.isNull((Object)cur), (String)"\u5df2\u5b58\u5728\u5f53\u524d\u884c\u653f\u533a\u57df\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        region.setTenantCode(TenantUtils.getTenantCode());
        region.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        region.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        region.setParentCode(Optional.ofNullable(region.getParentCode()).orElse("00"));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)region.getParentCode())) {
            Region parent = this.regionRepository.findByRegionCode(region.getParentCode());
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.getRuleCodeByParentCode(region.getParentCode());
        region.setRuleCode(ruleCode);
        region.setLevelNum(levelNum);
        this.regionRepository.save((Object)region);
        return region;
    }

    @Override
    @Transactional
    public Region update(Region region) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getId()), (String)"\u533a\u57dfid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionCode()), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionName()), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionCode().length() < 64 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionName().length() < 128 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        region.setParentCode(Optional.ofNullable(region.getParentCode()).orElse("00"));
        String currentId = region.getId();
        Region current = (Region)((Object)this.regionRepository.getById((Serializable)((Object)currentId)));
        Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.isTrue((boolean)region.getRegionCode().equals(current.getRegionCode()), (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        int levelNum = 1;
        if (StringUtils.isNotBlank((CharSequence)region.getParentCode())) {
            Region parent = this.regionRepository.findByRegionCode(region.getParentCode());
            levelNum = parent.getLevelNum() + 1;
        }
        region.setLevelNum(levelNum);
        this.regionRepository.updateById((Object)region);
        if (!region.getParentCode().equals(current.getRegionCode())) {
            String ruleCode = this.getRuleCodeByParentCode(region.getParentCode());
            this.updateCurAndChildrenRuleCode(region.getRegionCode(), ruleCode, levelNum);
        }
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionRepository.updateDeleteStatusByIds(ids);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.regionEventListenerList)) {
            List<Region> regions = this.regionRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(regions, Region.class, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (RegionEventListener event : this.regionEventListenerList) {
                event.onDelete(voList);
            }
        }
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.regionEventListenerList)) {
            List<Region> regions = this.regionRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(regions, Region.class, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (RegionEventListener event : this.regionEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    public List<Region> findRegionSelect(String parentCode, String regionName) {
        return this.regionRepository.findByParentCodeAndRegionNameLike(parentCode, regionName);
    }

    @Override
    public List<Region> findDetailByCodes(List<String> regionCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(regionCodeList)) {
            return new ArrayList<Region>(0);
        }
        return this.regionRepository.findDetailByCodes(regionCodeList);
    }

    @Override
    public List<Region> findSelfAndLowerByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return new ArrayList<Region>(0);
        }
        return this.regionRepository.findSelfAndLowerByRuleCode(ruleCode);
    }

    @Transactional
    public void updateCurAndChildrenRuleCode(String regionCode, String ruleCode, int levelNum) {
        Region region = this.regionRepository.findByRegionCode(regionCode);
        region.setRuleCode(ruleCode);
        region.setLevelNum(levelNum);
        this.regionRepository.updateById((Object)region);
        List<Region> childrenList = this.regionRepository.findByParentCode(region.getRegionCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getRegionCode(), ruleCode + treeRuleCodeStrategy.generateByNum(RegionConstant.RULE_CODE_LENGTH.intValue(), i + 1), levelNum + 1);
        }
    }

    private Page<Region> getPageRegionByList(List<Region> list) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            list = Lists.newLinkedList();
        }
        Page page = new Page();
        page.setTotal((long)list.size());
        page.setSize((long)list.size());
        page.setRecords((List)list);
        return page;
    }

    private String getRuleCodeByParentCode(String parentCode) {
        parentCode = Optional.ofNullable(parentCode).orElse("");
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            Region parent = this.regionRepository.findByRegionCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u884c\u653f\u533a\u57df\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<Region> childrenListByParentCode = this.regionRepository.findByParentCode(parentCode);
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, Region.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(RegionConstant.RULE_CODE_LENGTH.intValue(), parentRuleCode, (List)childrenDto);
    }
}

