package com.biz.crm.mdm.business.region.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import com.biz.crm.mdm.business.region.sdk.deprecated.dto.MdmRegionReqVo;
import com.biz.crm.mdm.business.region.sdk.deprecated.dto.MdmRegionSelectReqVo;
import com.biz.crm.mdm.business.region.sdk.deprecated.vo.MdmRegionRespVo;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 旧版本-行政区域
 *
 * @author sunx
 * @date 2020-11-20 14:59:37
 */
@Slf4j
@RestController
@RequestMapping("/mdmRegionController")
@Api(tags = "mdm-行政区域")
@Deprecated
public class MdmRegionController {

  @Autowired(required = false)
  private RegionService regionService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "查询列表（行政区域管理列表使用，其它地方不要用这个接口）")
  @PostMapping("/pageList")
  public Result<PageResult<MdmRegionRespVo>> pageList(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
    try {
      mdmRegionReqVo = Optional.ofNullable(mdmRegionReqVo).orElse(new MdmRegionReqVo());
      RegionPaginationDto regionPaginationDto = nebulaToolkitService
          .copyObjectByWhiteList(mdmRegionReqVo, RegionPaginationDto.class, HashSet.class,
              ArrayList.class);
      Page<Region> page = regionService.findByConditions(
          PageRequest.of(mdmRegionReqVo.getPageNum(), mdmRegionReqVo.getPageSize()),
          regionPaginationDto);
      List<MdmRegionRespVo> list = Lists.newLinkedList();
      if (CollectionUtils.isNotEmpty(page.getRecords())) {
        list = Lists
            .newArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(page.getRecords()
                , Region.class, MdmRegionRespVo.class, HashSet.class, ArrayList.class));
      }
      PageResult<MdmRegionRespVo> pageResult = PageResult.<MdmRegionRespVo>builder()
          .data(list)
          .count(page.getTotal())
          .build();
      return Result.ok(pageResult);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "regionCode", value = "区域编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/query")
  public Result<MdmRegionRespVo> query(@RequestParam(value = "id", required = false) String id,
      @RequestParam(value = "regionCode", required = false) String regionCode) {
    try {
      Region region = regionService.findDetailByIdOrCode(id, regionCode);
      if (Objects.isNull(region)) {
        return Result.error("行政区域信息不存在");
      }
      MdmRegionRespVo respVo = nebulaToolkitService
          .copyObjectByWhiteList(region, MdmRegionRespVo.class, HashSet.class, ArrayList.class);
      return Result.ok(respVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result<?> save(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
    try {
      if (Objects.isNull(mdmRegionReqVo)) {
        return Result.error("参数缺失");
      }
      Region region = nebulaToolkitService
          .copyObjectByWhiteList(mdmRegionReqVo, Region.class, HashSet.class, ArrayList.class);
      regionService.create(region);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result<?> update(@RequestBody MdmRegionReqVo mdmRegionReqVo) {
    try {
      if (Objects.isNull(mdmRegionReqVo)) {
        return Result.error("参数缺失");
      }
      Region region = nebulaToolkitService
          .copyObjectByWhiteList(mdmRegionReqVo, Region.class, HashSet.class, ArrayList.class);
      regionService.update(region);
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "启用")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result<?> enable(@RequestBody List<String> ids) {
    try {
      if (CollectionUtils.isEmpty(ids)) {
        return Result.error("参数缺失");
      }
      regionService.enableBatch(ids);
      return Result.ok("启用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "禁用")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result<?> disable(@RequestBody List<String> ids) {
    try {
      if (CollectionUtils.isEmpty(ids)) {
        return Result.error("参数缺失");
      }
      regionService.disableBatch(ids);
      return Result.ok("禁用成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("区域下拉框（传parentCode查该编码下级，不传查询省份，regionName模糊查询）")
  @PostMapping("/selectStartWithProvince")
  public Result<List<Region>> selectStartWithProvince(@RequestBody MdmRegionSelectReqVo reqVo) {
    reqVo = Optional.ofNullable(reqVo).orElse(new MdmRegionSelectReqVo());
    return Result.ok(regionService.findRegionSelect(reqVo.getParentCode(), reqVo.getRegionName()));
  }
}
