package com.biz.crm.mdm.business.region.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.List;

/**
 * 行政区域实体
 *
 * @author sunx
 * @date 2020-11-20 14:59:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_region")
@ApiModel(value = "RegionEntity", description = "行政区域")
@Table(
    name = "mdm_region",
    indexes = {
        @Index(name = "mdm_region_index1", unique = true, columnList = "region_code"),
        @Index(name = "mdm_region_index2", columnList = "parent_code"),
        @Index(name = "mdm_region_rule_index1", columnList = "tenant_code, del_flag, rule_code, region_level, region_name")
    })
@org.hibernate.annotations.Table(appliesTo = "mdm_region", comment = "行政区域")
public class Region extends TenantFlagOpEntity {
  private static final long serialVersionUID = 6247398465820076821L;

  /**
   * CRM行政区域编码
   */
  @TableField(value = "region_code")
  @Column(name = "region_code", length = 16, columnDefinition = "VARCHAR(16) COMMENT 'CRM行政区域编码'")
  @ApiModelProperty("CRM行政区域编码")
  private String regionCode;

  /**
   * CRM行政区域名称
   */
  @TableField(value = "region_name")
  @Column(name = "region_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT 'CRM行政区域名称'")
  @ApiModelProperty("CRM行政区域名称")
  private String regionName;

  /**
   * CRM上级行政区域编码
   */
  @TableField(value = "parent_code")
  @Column(name = "parent_code", length = 16, columnDefinition = "VARCHAR(16) COMMENT 'CRM上级行政区域编码'")
  @ApiModelProperty("CRM上级行政区域编码")
  private String parentCode;

  /**
   * 区域等级
   */
  @TableField(value = "region_level")
  @Column(name = "region_level", columnDefinition = "INT COMMENT '区域等级'")
  @ApiModelProperty("区域等级")
  private Integer regionLevel;

  /**
   * 国家统计局行政区域编码
   */
  @TableField(value = "gov_region_code")
  @Column(
      name = "gov_region_code",
      length = 16,
      columnDefinition = "VARCHAR(16) COMMENT '国家统计局行政区域编码'")
  @ApiModelProperty("国家统计局行政区域编码")
  private String govRegionCode;

  /**
   * 国家统计局上级行政区域编码
   */
  @TableField(value = "gov_parent_code")
  @Column(
      name = "gov_parent_code",
      length = 16,
      columnDefinition = "VARCHAR(16) COMMENT '国家统计局上级行政区域编码'")
  @ApiModelProperty("国家统计局上级行政区域编码")
  private String govParentCode;

  /**
   * 国家统计局URL
   */
  @TableField(value = "gov_url")
  @Column(name = "gov_url", length = 128, columnDefinition = "VARCHAR(128) COMMENT '国家统计局URL'")
  @ApiModelProperty("国家统计局URL")
  private String govUrl;

  /**
   * 邮政编码
   */
  @TableField(value = "email")
  @Column(name = "email", length = 8, columnDefinition = "VARCHAR(8) COMMENT '邮政编码'")
  @ApiModelProperty("邮政编码")
  private String email;

  /**
   * 经度
   */
  @TableField(value = "longitude")
  @Column(name = "longitude", columnDefinition = "DECIMAL(12,8) COMMENT '经度'")
  @ApiModelProperty("经度")
  private BigDecimal longitude;

  /**
   * 纬度
   */
  @TableField(value = "latitude")
  @Column(name = "latitude", columnDefinition = "DECIMAL(12,8) COMMENT '纬度'")
  @ApiModelProperty("纬度")
  private BigDecimal latitude;

  /**
   * 降维码
   */
  @TableField(value = "rule_code")
  @Column(name = "rule_code", length = 50, columnDefinition = "VARCHAR(50) COMMENT '降维码'")
  @ApiModelProperty("降维码")
  private String ruleCode;

  /**
   * 层级
   */
  @TableField(value = "level_num")
  @Column(name = "level_num", columnDefinition = "int COMMENT '层级'")
  @ApiModelProperty("层级")
  private Integer levelNum;

  /**
   * 是否有子节点
   */
  @TableField(value = "has_child")
  @Column(name = "has_child", length = 8, columnDefinition = "VARCHAR(64) COMMENT 'CRM行政区域名称'")
  @ApiModelProperty("是否有子节点")
  private Boolean hasChild;

  /**
   * 城市等级
   */
  @TableField(value = "city_level")
  @Column(name = "city_level", length = 40, columnDefinition = "VARCHAR(40) COMMENT '城市等级'")
  @ApiModelProperty("城市等级")
  private String cityLevel;

  /**
   * 标签集合
   */
  @ApiModelProperty("标签集合")
  @TableField(exist = false)
  @OneToMany
  private List<RegionLabel> lableList;

  /**
   * 当前节点下是否存在子节点,对应字段 has_child: 0=false 1=true
   */
  @TableField(exist = false)
  @Transient
  private Integer hasChildFlag;

  /**
   * 当前组织父名称
   */
  @TableField(exist = false)
  @Transient
  private String parentName;
  /**
   * 省
   */
  @TableField(exist = false)
  @Transient
  private String provinceCode;
  /**
   * 市
   */
  @TableField(exist = false)
  @Transient
  private String cityCode;
  /**
   * 区
   */
  @TableField(exist = false)
  @Transient
  private String districtCode;
  /**
   * 街道
   */
  @TableField(exist = false)
  @Transient
  private String streetCode;



}
