package com.biz.crm.mdm.business.region.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.region.local.imports.vo.RegionCityLevelImportVO;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @ClassName RegionCityLevelImportHandler
 * @Description
 * @Author: jiangyin
 * @Date 2023/2/8
 */
@Component
@Slf4j
public class RegionCityLevelImportProcess implements ImportProcess<RegionCityLevelImportVO> {

    @Autowired(required = false)
    private RegionService regionService;

    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, RegionCityLevelImportVO> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        regionService.saveCityLevel(data);
        return null;
    }

    @Override
    public Class<RegionCityLevelImportVO> findCrmExcelVoClass() {
        return RegionCityLevelImportVO.class;
    }

    @Override
    public String getTemplateCode() {
        return "MDM_REGION_CITY_LEVEL_IMPORT";
    }

    @Override
    public String getTemplateName() {
        return "MDM行政区域城市等级导入";
    }
}
