package com.biz.crm.mdm.business.region.local.repository;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.region.local.entity.RegionLabel;
import com.biz.crm.mdm.business.region.local.mapper.RegionLabelMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 行政区域(MdmRegionLabel)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-08-02 15:41:03
 */
@Component
public class RegionLabelRepository extends ServiceImpl<RegionLabelMapper, RegionLabel> {

  /**
   * 删除标签
   *
   * @param regionCodes
   */
  public void deleteHandle(List<String> regionCodes) {
    this.lambdaUpdate()
            .in(RegionLabel::getRegionCode, regionCodes)
            .in(RegionLabel::getTenantCode, TenantUtils.getTenantCode())//新增租户编号条件
            .remove();
  }

  /**
   * 通过行政区域编码集合查询
   *
   * @param regionCodes
   * @return
   */
  public List<RegionLabel> findByRegionCodes(List<String> regionCodes) {
    return this.lambdaQuery()
            .in(RegionLabel::getRegionCode, regionCodes)
            .in(RegionLabel::getTenantCode, TenantUtils.getTenantCode())//新增租户编号条件
            .list();
  }

  public List<RegionLabel> findByLabel(String s) {
    return this.lambdaQuery()
            .eq(RegionLabel::getLabel, s)
            .eq(RegionLabel::getTenantCode, TenantUtils.getTenantCode())//新增租户编号条件
            .list();
  }

  public List<RegionLabel> findByLabelList(List<String> labelList) {
    return this.lambdaQuery()
            .in(RegionLabel::getLabel, labelList)
            .in(RegionLabel::getTenantCode, TenantUtils.getTenantCode())//新增租户编号条件
            .list();
  }
}

