/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.mapper.RegionMapper;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import com.biz.crm.mdm.business.region.sdk.vo.LazyTreeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class RegionRepository
extends ServiceImpl<RegionMapper, Region> {
    public Page<Region> findByConditions(Page<Region> page, RegionPaginationDto regionPaginationDto) {
        return ((RegionMapper)this.baseMapper).findByConditions(page, regionPaginationDto, TenantUtils.getTenantCode());
    }

    public List<Region> findByParentCode(String parentCode) {
        if (StringUtils.isBlank((CharSequence)parentCode)) {
            return Lists.newLinkedList();
        }
        return ((RegionMapper)this.baseMapper).findByParentCodeAndRegionNameLike(parentCode, "", TenantUtils.getTenantCode());
    }

    public List<Region> findByParentCodeAndRegionNameLike(String parentCode, String regionName) {
        parentCode = Optional.ofNullable(parentCode).orElse("");
        regionName = Optional.ofNullable(regionName).orElse("");
        return ((RegionMapper)this.baseMapper).findByParentCodeAndRegionNameLike(parentCode, regionName, TenantUtils.getTenantCode());
    }

    public List<Region> findAllProvince() {
        return ((RegionMapper)this.baseMapper).findByParentCodeAndRegionNameLike("00", "", TenantUtils.getTenantCode());
    }

    public Region findById(String id) {
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public Region findByRegionCode(String regionCode) {
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Region::getRegionCode, (Object)regionCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public Region findByGovRegionCode(String govRegionCode) {
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Region::getGovRegionCode, (Object)govRegionCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    @Transactional
    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.set((Object)"enable_status", (Object)enable.getCode());
        updateWrapper.in((Object)"id", ids);
        updateWrapper.in((Object)"tenant_code", new Object[]{TenantUtils.getTenantCode()});
        this.update((Wrapper)updateWrapper);
    }

    @Transactional
    public void updateDeleteStatusByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<Region> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public List<Region> findByRegionCodes(List<String> regionCodeList) {
        if (CollectionUtils.isEmpty(regionCodeList)) {
            return Lists.newLinkedList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Region::getRegionCode, regionCodeList)).in(TenantFlagOpEntity::getTenantCode, new Object[]{TenantUtils.getTenantCode()})).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<String> findRuleCodeListByParams(Integer levelNum, List<String> ruleCodeList, String regionName, String regionCode, String regionLevel, String tenantCode) {
        return ((RegionMapper)this.baseMapper).findRuleCodeListByParams(levelNum, ruleCodeList, regionName, regionCode, regionLevel, tenantCode);
    }

    public List<Region> findByRuleCods(List<String> ruleCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Region::getRuleCode, ruleCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).orderByAsc(Region::getRegionCode)).list();
    }

    public Region findByParentCodeAndRegionName(String parentCode, String regionName) {
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Region::getParentCode, (Object)parentCode)).eq(Region::getRegionName, (Object)regionName)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public List<Region> findDetailByCodes(List<String> regionCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Region::getRegionCode, regionCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<Region> findSelfAndLowerByRuleCode(String ruleCode) {
        return ((RegionMapper)this.baseMapper).findSelfAndLowerByRuleCode(ruleCode, TenantUtils.getTenantCode());
    }

    public Region findByIdAndTenantCode(String currentId, String tenantCode) {
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidEntity::getId, (Object)currentId)).one());
    }

    public void updateByIdAndTenantCode(Region region, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{region.getId()});
        ((RegionMapper)this.baseMapper).update((Object)region, (Wrapper)lambdaUpdateWrapper);
    }

    public List<Region> findByRegionLevel(String regionLevel, String regionName) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Region::getRegionLevel, (Object)regionLevel)).like(StringUtils.isNotEmpty((CharSequence)regionName), Region::getRegionName, (Object)regionName)).orderByAsc(Region::getRegionCode)).list();
    }

    public List<Region> findByGovRegionCodes(List<String> govRegionCodeList) {
        if (CollectionUtils.isEmpty(govRegionCodeList)) {
            return Lists.newLinkedList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Region::getGovRegionCode, govRegionCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<Region> findChildByParentCode(String parentCode, String tenantCode) {
        return ((RegionMapper)this.baseMapper).findChildByParentCode(parentCode, tenantCode);
    }

    public Region findDetailsByCode(String regionCode, String tenantCode) {
        Validate.notBlank((CharSequence)regionCode, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(Region::getRegionCode, (Object)regionCode)).one());
    }

    public List<LazyTreeVo> findLazyTreeList(String enableStatus, Boolean topOnly, String parentCode, List<String> codeList, List<String> ruleCodeList, String excludeRuleCode, String tenantCode) {
        return ((RegionMapper)this.baseMapper).findLazyTreeList(enableStatus, topOnly, parentCode, codeList, ruleCodeList, excludeRuleCode, tenantCode, DelFlagStatusEnum.NORMAL);
    }
}

