/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.sdk.dto.TreeDto;
import com.biz.crm.mdm.business.region.sdk.event.RegionSaleTerritoryEventListener;
import com.biz.crm.mdm.business.region.sdk.service.RegionLazyTreeVoService;
import com.biz.crm.mdm.business.region.sdk.utils.TreeUtil;
import com.biz.crm.mdm.business.region.sdk.vo.LazyTreeVo;
import com.biz.crm.mdm.business.region.sdk.vo.RegionSaleTerritoryVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="RegionLazyTreeVoServiceImpl")
public class RegionLazyTreeVoServiceImpl
implements RegionLazyTreeVoService {
    @Autowired(required=false)
    private RegionRepository regionRepository;
    @Autowired(required=false)
    private RegionSaleTerritoryEventListener regionSaleTerritoryEventListener;
    private static volatile Cache<String, List<LazyTreeVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RegionLazyTreeVoServiceImpl() {
        if (cache != null) return;
        Class<RegionLazyTreeVoServiceImpl> clazz = RegionLazyTreeVoServiceImpl.class;
        synchronized (RegionLazyTreeVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<LazyTreeVo> findLazyTree(TreeDto treeDto) {
        List<LazyTreeVo> regionTree;
        Region one;
        treeDto = Optional.ofNullable(treeDto).orElse(new TreeDto());
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getExcludeCodeAndChildren()) && (one = this.regionRepository.findDetailsByCode(treeDto.getExcludeCodeAndChildren(), TenantUtils.getTenantCode())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((CharSequence)treeDto.getParentCode())) {
            List<LazyTreeVo> result = this.regionRepository.findLazyTreeList(treeDto.getEnableStatus(), null, treeDto.getParentCode(), null, null, excludeRuleCode, TenantUtils.getTenantCode());
            boolean disable = treeDto.getDisable();
            if (CollectionUtils.isNotEmpty(result)) {
                if (!disable) {
                    regionTree = this.setStatus(result);
                    if (CollectionUtils.isNotEmpty(regionTree)) {
                        list.addAll(regionTree);
                    }
                } else {
                    result.forEach(r -> r.setDisabled(Boolean.valueOf(true)));
                    list.addAll(result);
                }
            }
        } else {
            List regionCache = (List)cache.getIfPresent((Object)"region");
            if (CollectionUtils.isNotEmpty((Collection)regionCache)) {
                List<LazyTreeVo> regionTree2 = this.setStatus(regionCache);
                if (CollectionUtils.isNotEmpty(regionTree2)) {
                    list.addAll(regionTree2);
                }
            } else {
                List<LazyTreeVo> result = this.regionRepository.findLazyTreeList(treeDto.getEnableStatus(), false, "00", null, null, excludeRuleCode, TenantUtils.getTenantCode());
                if (CollectionUtils.isEmpty(result)) {
                    return null;
                }
                cache.put((Object)"region", result);
                regionTree = this.setStatus(result);
                if (CollectionUtils.isNotEmpty(regionTree)) {
                    list.addAll(regionTree);
                }
            }
        }
        if (!CollectionUtils.isEmpty(list)) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LazyTreeVo lazyTreeVo;
                lazyTreeVo.setHasChild(Boolean.valueOf(null != (lazyTreeVo = (LazyTreeVo)iterator.next()).getHasChildFlag() && lazyTreeVo.getHasChildFlag().compareTo(0) > 0));
            }
            return TreeUtil.generateLazyTreeByParentCode(list);
        }
        return new ArrayList<LazyTreeVo>();
    }

    private List<LazyTreeVo> setStatus(List<LazyTreeVo> result) {
        List saleRegionVos;
        ArrayList<LazyTreeVo> list = new ArrayList<LazyTreeVo>();
        ArrayList regionCodes = new ArrayList();
        if (!CollectionUtils.isEmpty(result)) {
            result.forEach(r -> regionCodes.add(r.getCode()));
        }
        if (CollectionUtils.isEmpty((Collection)(saleRegionVos = this.regionSaleTerritoryEventListener.findSaleTerritoryCodeByRegionCodes(regionCodes)))) {
            result.forEach(r -> r.setDisabled(Boolean.valueOf(false)));
            list.addAll(result);
        } else {
            Set collect = saleRegionVos.stream().map(RegionSaleTerritoryVo::getRegionCode).collect(Collectors.toSet());
            result.stream().forEach(r -> {
                if (collect.contains(r.getCode())) {
                    r.setDisabled(Boolean.valueOf(true));
                } else {
                    r.setDisabled(Boolean.valueOf(false));
                }
            });
            if (CollectionUtils.isNotEmpty(result)) {
                list.addAll(result);
            }
        }
        return list;
    }
}

