/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.TreeDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategy;
import com.biz.crm.business.common.sdk.service.TreeRuleCodeStrategyHolder;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.entity.RegionLabel;
import com.biz.crm.mdm.business.region.local.imports.vo.RegionCityLevelImportVO;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.local.service.RegionLabelService;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import com.biz.crm.mdm.business.region.sdk.constant.RegionConstant;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import com.biz.crm.mdm.business.region.sdk.enums.RegionLevelEnum;
import com.biz.crm.mdm.business.region.sdk.event.RegionEventListener;
import com.biz.crm.mdm.business.region.sdk.vo.RegionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="regionService")
public class RegionServiceImpl
implements RegionService {
    @Autowired(required=false)
    private RegionRepository regionRepository;
    private static final int PROVINCE_SIZE = 4;
    private static final int MAX_RULECODE_IN_ONE_Level = 999;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<RegionEventListener> regionEventListenerList;
    @Autowired(required=false)
    private TreeRuleCodeStrategyHolder treeRuleCodeStrategyHolder;
    @Autowired
    private RegionLabelService regionLabelService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    @Override
    public Page<Region> findByConditions(Pageable pageable, RegionPaginationDto regionPaginationDto) {
        Page page;
        Page<Region> result;
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)200));
        if (Objects.isNull(regionPaginationDto)) {
            regionPaginationDto = new RegionPaginationDto();
        }
        regionPaginationDto.setTenantCode(TenantUtils.getTenantCode());
        Validate.isTrue((boolean)(StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionCode()) ? true : regionPaginationDto.getRegionCode().length() < 64), (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u641c\u7d22\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((boolean)(StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionName()) ? true : regionPaginationDto.getRegionName().length() < 128), (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u641c\u7d22\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)regionPaginationDto.getParentCode())) {
            Region region = (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(Region::getRegionCode, (Object)regionPaginationDto.getParentCode())).one());
            if (Objects.isNull((Object)region)) {
                return this.getPageRegionByList(null);
            }
            regionPaginationDto.setRegionLevel(Integer.valueOf(region.getRegionLevel() + 1));
            regionPaginationDto.setRegionCode(null);
            regionPaginationDto.setGovRegionCode(null);
            regionPaginationDto.setRegionName(null);
        }
        if (null == regionPaginationDto.getRegionLevel() && StringUtils.isBlank((CharSequence)regionPaginationDto.getGovRegionCode()) && StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionCode()) && StringUtils.isBlank((CharSequence)regionPaginationDto.getRegionName())) {
            regionPaginationDto.setRegionLevel(Integer.valueOf(1));
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)(result = this.regionRepository.findByConditions((Page<Region>)(page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize())), regionPaginationDto)).getRecords())) {
            return this.getPageRegionByList(null);
        }
        return this.getPageRegionByList(result.getRecords());
    }

    private List<Region> selectLabel(List<Region> list) {
        List<String> regionCodes = list.stream().map(Region::getRegionCode).collect(Collectors.toList());
        List<RegionLabel> regionLabels = this.regionLabelService.findByRegionCodes(regionCodes);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(regionLabels)) {
            return list;
        }
        Map<String, List<RegionLabel>> map = regionLabels.stream().collect(Collectors.groupingBy(RegionLabel::getRegionCode));
        for (Region region : list) {
            region.setLableList(map.get(region.getRegionCode()));
        }
        return list;
    }

    @Override
    public Region findDetailByIdOrCode(String id, String regionCode) {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)regionCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        String string = tenantCode = StringUtils.isBlank((CharSequence)tenantCode) ? "default" : tenantCode;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            int i;
            Region region = this.regionRepository.findById(id);
            Region parentRegion = (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionRepository.lambdaQuery().eq(Region::getRegionCode, (Object)region.getParentCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).one());
            region.setParentName(parentRegion.getRegionName());
            ArrayList<String> codeList = new ArrayList<String>(4);
            String tempParentCode = region.getParentCode();
            for (i = 1; i < region.getRegionLevel(); ++i) {
                Region tempRegion = (Region)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionRepository.lambdaQuery().eq(Region::getRegionCode, (Object)tempParentCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).one());
                tempParentCode = tempRegion.getParentCode();
                codeList.add(tempRegion.getRegionName());
            }
            Collections.reverse(codeList);
            block13: for (i = 0; i < codeList.size(); ++i) {
                switch (String.valueOf(i + 1)) {
                    case "1": {
                        region.setProvinceCode((String)codeList.get(i));
                        continue block13;
                    }
                    case "2": {
                        region.setCityCode((String)codeList.get(i));
                        continue block13;
                    }
                    case "3": {
                        region.setDistrictCode((String)codeList.get(i));
                        continue block13;
                    }
                    case "4": {
                        region.setStreetCode((String)codeList.get(i));
                    }
                }
            }
            return region;
        }
        return this.regionRepository.findByRegionCode(regionCode);
    }

    @Override
    @Transactional
    public Region create(Region region) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionCode()), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionName()), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionCode().length() < 64 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionName().length() < 128 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Region cur = this.regionRepository.findByRegionCode(region.getRegionCode());
        Validate.isTrue((boolean)Objects.isNull((Object)cur), (String)"\u5df2\u5b58\u5728\u5f53\u524d\u884c\u653f\u533a\u57df\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        region.setTenantCode(TenantUtils.getTenantCode());
        region.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        region.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        region.setParentCode(Optional.ofNullable(region.getParentCode()).orElse("00"));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((CharSequence)region.getParentCode())) {
            Region parent = this.regionRepository.findByRegionCode(region.getParentCode());
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = null;
        if (RegionLevelEnum.ONE.getDictCode().equals(String.valueOf(region.getRegionLevel()))) {
            ruleCode = this.getRuleCodeByProvince();
        } else if (!RegionLevelEnum.ZERO.getDictCode().equals(String.valueOf(region.getRegionLevel()))) {
            ruleCode = this.getRuleCodeByParentCode(region.getParentCode());
        }
        region.setRuleCode(ruleCode);
        region.setLevelNum(levelNum);
        this.regionRepository.save((Object)region);
        return region;
    }

    @Override
    @Transactional
    public Region update(Region region) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getId()), (String)"\u533a\u57dfid\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionCode()), (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)region.getRegionName()), (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionCode().length() < 64 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((region.getRegionName().length() < 128 ? 1 : 0) != 0, (String)"\u884c\u653f\u533a\u57df\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u8f93\u5165\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        region.setParentCode(Optional.ofNullable(region.getParentCode()).orElse("00"));
        String currentId = region.getId();
        Region current = this.regionRepository.findByIdAndTenantCode(currentId, TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)current), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        Validate.isTrue((boolean)region.getRegionCode().equals(current.getRegionCode()), (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u7f16\u8f91", (Object[])new Object[0]);
        int levelNum = 1;
        if (StringUtils.isNotBlank((CharSequence)region.getParentCode())) {
            Region parent = this.regionRepository.findByRegionCode(region.getParentCode());
            levelNum = parent.getLevelNum() + 1;
        }
        region.setLevelNum(levelNum);
        this.regionRepository.updateByIdAndTenantCode(region, TenantUtils.getTenantCode());
        if (!region.getParentCode().equals(current.getRegionCode())) {
            String ruleCode = this.getRuleCodeByParentCode(region.getParentCode());
            this.updateCurAndChildrenRuleCode(region.getRegionCode(), ruleCode, levelNum);
        }
        return current;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void delete(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Region> regionList = this.regionRepository.findByIds(ids);
        for (Region item : regionList) {
            int parentSize = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionRepository.lambdaQuery().eq(Region::getParentCode, (Object)item.getRegionCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).count();
            Validate.isTrue((parentSize <= 0 ? 1 : 0) != 0, (String)("\u533a\u57df\u540d\u79f0:\u3010" + item.getRegionName() + "\u3011\u5b58\u5728\u3010" + parentSize + "\u3011\u6761\u4e0b\u7ea7\u5173\u7cfb\uff0c\u7981\u6b62\u5220\u9664!"), (Object[])new Object[0]);
        }
        this.regionRepository.updateDeleteStatusByIds(ids);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.regionEventListenerList)) {
            List<Region> regions = this.regionRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(regions, Region.class, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (RegionEventListener event : this.regionEventListenerList) {
                event.onDelete(voList);
            }
        }
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(this.regionEventListenerList)) {
            List<Region> regions = this.regionRepository.findByIds(ids);
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(regions, Region.class, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
            for (RegionEventListener event : this.regionEventListenerList) {
                event.onDisable(voList);
            }
        }
    }

    @Override
    public List<Region> findRegionSelect(String parentCode, String regionName) {
        return this.regionRepository.findByParentCodeAndRegionNameLike(parentCode, regionName);
    }

    @Override
    public List<Region> findDetailByCodes(List<String> regionCodeList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(regionCodeList)) {
            return new ArrayList<Region>(0);
        }
        return this.regionRepository.findDetailByCodes(regionCodeList);
    }

    @Override
    public List<Region> findSelfAndLowerByRuleCode(String ruleCode) {
        if (StringUtils.isBlank((CharSequence)ruleCode)) {
            return new ArrayList<Region>(0);
        }
        return this.regionRepository.findSelfAndLowerByRuleCode(ruleCode);
    }

    @Override
    public List<RegionVo> findByRegionLevel(String regionLevel, String regionName) {
        if (StringUtils.isEmpty((CharSequence)regionLevel)) {
            regionLevel = RegionLevelEnum.ONE.getDictCode();
        }
        List<Region> result = this.regionRepository.findByRegionLevel(regionLevel, regionName);
        if (RegionLevelEnum.TWO.getDictCode().equals(regionLevel)) {
            result.addAll(this.regionRepository.findByRegionLevel(RegionLevelEnum.ONE.getDictCode(), regionName));
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(result, Region.class, RegionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<Region> findChildByParentCode(String parentCode) {
        String tenantCode = TenantUtils.getTenantCode();
        tenantCode = StringUtils.isBlank((CharSequence)tenantCode) ? "default" : tenantCode;
        List<Region> list = this.regionRepository.findChildByParentCode(parentCode, tenantCode);
        list.stream().peek(a -> a.setHasChild(a.getHasChildFlag() == 1)).collect(Collectors.toList());
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCityLevel(LinkedHashMap<Integer, RegionCityLevelImportVO> data) {
        ArrayList<RegionCityLevelImportVO> importList = new ArrayList<RegionCityLevelImportVO>(data.values());
        Set regionCodeSet = importList.stream().map(RegionCityLevelImportVO::getRegionCode).filter(Objects::nonNull).collect(Collectors.toSet());
        if (regionCodeSet.size() != importList.size()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u6709\u91cd\u590d\u7684\u884c\u653f\u533a\u57df\u7f16\u7801\u6216\u6ca1\u6709\u884c\u653f\u533a\u57df\u7f16\u7801");
        }
        String CITY_LEVEL_DICT_CODE = "region_city_level";
        List cityLevelDict = this.dictDataVoService.findByDictTypeCode(CITY_LEVEL_DICT_CODE);
        Map<String, String> cityLevelDictMap = cityLevelDict.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
        List<Region> regionList = this.regionRepository.findByGovRegionCodes(new ArrayList<String>(regionCodeSet));
        if (regionList.size() != importList.size()) {
            throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u7684\u884c\u653f\u533a\u57df\u7f16\u7801\u5b58\u5728\u65e0\u5173\u8054\u6570\u636e");
        }
        Map<String, RegionCityLevelImportVO> importMap = importList.stream().collect(Collectors.toMap(RegionCityLevelImportVO::getRegionCode, o -> o));
        for (Region region : regionList) {
            RegionCityLevelImportVO levelImportVO = importMap.get(region.getGovRegionCode());
            if (levelImportVO == null) continue;
            region.setCityLevel(cityLevelDictMap.get(levelImportVO.getCityLevel()));
        }
        this.regionRepository.updateBatchById(regionList);
    }

    @Transactional
    public void updateCurAndChildrenRuleCode(String regionCode, String ruleCode, int levelNum) {
        Region region = this.regionRepository.findByRegionCode(regionCode);
        region.setRuleCode(ruleCode);
        region.setLevelNum(levelNum);
        this.regionRepository.updateByIdAndTenantCode(region, TenantUtils.getTenantCode());
        List<Region> childrenList = this.regionRepository.findByParentCode(region.getRegionCode());
        if (CollectionUtils.isEmpty(childrenList)) {
            return;
        }
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        for (int i = 0; i < childrenList.size(); ++i) {
            this.updateCurAndChildrenRuleCode(childrenList.get(i).getRegionCode(), ruleCode + treeRuleCodeStrategy.generateByNum(RegionConstant.RULE_CODE_LENGTH.intValue(), i + 1), levelNum + 1);
        }
    }

    private Page<Region> getPageRegionByList(List<Region> list) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            list = Lists.newLinkedList();
        }
        Page page = new Page();
        page.setTotal((long)list.size());
        page.setSize((long)list.size());
        page.setRecords((List)list);
        return page;
    }

    private String getRuleCodeByParentCode(String parentCode) {
        parentCode = Optional.ofNullable(parentCode).orElse("");
        String parentRuleCode = null;
        if (StringUtils.isNotEmpty((CharSequence)parentCode)) {
            Region parent = this.regionRepository.findByRegionCode(parentCode);
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u884c\u653f\u533a\u57df\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            parentRuleCode = parent.getRuleCode();
        }
        List<Region> childrenListByParentCode = this.regionRepository.findByParentCode(parentCode);
        ArrayList childrenDto = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(childrenListByParentCode, Region.class, TreeDto.class, HashSet.class, ArrayList.class, new String[0]));
        TreeRuleCodeStrategy treeRuleCodeStrategy = this.treeRuleCodeStrategyHolder.getStrategy(null);
        return treeRuleCodeStrategy.generate(RegionConstant.RULE_CODE_LENGTH.intValue(), parentRuleCode, (List)childrenDto);
    }

    private String getRuleCodeByProvince() {
        String ruleCode = null;
        List regionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.regionRepository.lambdaQuery().eq(Region::getRegionLevel, (Object)RegionLevelEnum.ONE.getDictCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).orderByAsc(Region::getRuleCode)).list();
        List codeList = regionList.stream().map(Region::getRuleCode).collect(Collectors.toList());
        HashSet<Integer> set = new HashSet<Integer>();
        for (String item : codeList) {
            set.add(Integer.parseInt(item));
        }
        for (int i = 1; i <= 999; ++i) {
            Validate.isTrue((i != 999 ? 1 : 0) != 0, (String)"\u964d\u7ef4\u7f16\u7801\u8d8a\u754c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406", (Object[])new Object[0]);
            if (set.contains(i)) continue;
            ruleCode = String.format("%03d", i);
            break;
        }
        return ruleCode;
    }
}

