/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.biz.crm.business.common.sdk.utils.TreeUtil;
import com.biz.crm.business.common.sdk.vo.TreeVo;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.sdk.constant.RegionConstant;
import com.biz.crm.mdm.business.region.sdk.enums.RegionLevelEnum;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.biz.crm.mdm.business.region.sdk.vo.RegionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="regionVoService")
public class RegionVoServiceImpl
implements RegionVoService {
    @Autowired(required=false)
    private RegionRepository regionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Map<String, String> findRegionCodeNameMap(List<String> regionCodeList) {
        List<Region> list = this.regionRepository.findByRegionCodes(regionCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(Region::getRegionCode, Region::getRegionName, (a, b) -> a));
    }

    public String findRegionCode(String regionName, String parentCode) {
        Region region = this.regionRepository.findByParentCodeAndRegionName(parentCode, regionName);
        if (Objects.isNull((Object)region)) {
            return null;
        }
        return region.getRegionCode();
    }

    public List<RegionVo> findByRegionLevel(String regionLevel, String regionName) {
        if (StringUtils.isEmpty((CharSequence)regionLevel)) {
            regionLevel = RegionLevelEnum.ONE.getDictCode();
        }
        List<Region> result = this.regionRepository.findByRegionLevel(regionLevel, regionName);
        if (RegionLevelEnum.TWO.getDictCode().equals(regionLevel)) {
            result.addAll(this.regionRepository.findByRegionLevel(RegionLevelEnum.ONE.getDictCode(), regionName));
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(result, Region.class, RegionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public RegionVo findByRegionCode(String regionCode) {
        Validate.notNull((Object)regionCode, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Region region = this.regionRepository.findByRegionCode(regionCode);
        if (ObjectUtils.isNotEmpty((Object)((Object)region))) {
            RegionVo regionVo = (RegionVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)region, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
            return regionVo;
        }
        return null;
    }

    public List<RegionVo> findByParentCode(String parentCode) {
        Validate.notNull((Object)parentCode, (String)"\u7236\u7ea7\u884c\u653f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<Region> regions = this.regionRepository.findByParentCode(parentCode);
        List regionVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(regions, Region.class, RegionVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty((Collection)regionVos)) {
            return null;
        }
        return regionVos;
    }

    public List<TreeVo> findRegionTreeByRegionCode(String regionCode, List<String> items) {
        Validate.notNull((Object)regionCode, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull(items, (String)"\u5173\u8054\u9500\u552e\u533a\u57df\u7684\u884c\u653f\u533a\u57df\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        List<TreeVo> children = this.findChildrenByRegionCode(regionCode, items);
        if (CollectionUtils.isEmpty(children)) {
            return null;
        }
        return children;
    }

    private List<TreeVo> findChildrenByRegionCode(String regionCode, List<String> items) {
        List<Region> regionList = this.regionRepository.findByParentCode(regionCode);
        List regions = regionList.stream().filter(r -> items.contains(r.getRegionCode())).collect(Collectors.toList());
        List collect = regions.stream().map(x -> {
            TreeVo treeVo = new TreeVo();
            treeVo.setId(x.getId());
            treeVo.setParentCode(x.getParentCode());
            treeVo.setCode(x.getRegionCode());
            treeVo.setName(x.getRegionName());
            if (!x.getLevelNum().equals(RegionConstant.LEVEL_NUM)) {
                List<TreeVo> children = this.findChildrenByRegionCode(x.getRegionCode(), items);
                treeVo.setChildren(children);
            }
            return treeVo;
        }).collect(Collectors.toList());
        List treeVos = TreeUtil.generateTreeByParentCode(collect);
        return treeVos;
    }
}

