/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import com.biz.crm.mdm.business.region.sdk.dto.RegionPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/region/region"})
@Api(tags={"\u884c\u653f\u533a\u57df\u7ba1\u7406: Region: \u884c\u653f\u533a\u57df\u7ba1\u7406"})
public class RegionController {
    private static final Logger log = LoggerFactory.getLogger(RegionController.class);
    @Autowired(required=false)
    private RegionService regionService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<Region>> findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="regionDto", value="\u8bf7\u6c42\u53c2\u6570") RegionPaginationDto regionPaginationDto) {
        try {
            Page<Region> result = this.regionService.findByConditions(pageable, regionPaginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u884c\u653f\u533a\u57df\u7f16\u7801\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="regionCode", value="regionCode", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/findDetailByRegionCode"})
    public Result<Region> findDetailByRegionCode(@RequestParam(value="regionCode") String regionCode) {
        try {
            return Result.ok((Object)((Object)this.regionService.findDetailByIdOrCode(null, regionCode)));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u884c\u653f\u533a\u57df\u4fe1\u606f")
    @GetMapping(value={"/findDetailById"})
    public Result<Region> findDetailById(@RequestParam(value="id") @ApiParam(value="\u4e3b\u952e") String id) {
        try {
            Region result = this.regionService.findDetailByIdOrCode(id, null);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u884c\u653f\u533a\u57df")
    @PostMapping
    public Result<Region> create(@RequestBody @ApiParam(name="region", value="\u884c\u653f\u533a\u57df") Region region) {
        try {
            Region current = this.regionService.create(region);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u884c\u653f\u533a\u57df")
    @PatchMapping
    public Result<Region> update(@RequestBody @ApiParam(name="region", value="\u884c\u653f\u533a\u57df") Region region) {
        try {
            Region current = this.regionService.update(region);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664")
    @PatchMapping(value={"/delete"})
    public Result<?> delete(@RequestBody List<String> ids) {
        try {
            this.regionService.delete(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.regionService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.regionService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u884c\u653f\u533a\u57df\u4e0b\u62c9,\u4e0d\u4f20parentCode\u9ed8\u8ba4\u67e5\u8be2\u7684\u662f\u4e2d\u56fd,\u4e2d\u56fdregionCode=00")
    @GetMapping(value={"/findRegionSelect"})
    public Result<List<Region>> findRegionSelect(@RequestParam(value="parentCode", required=false) String parentCode, @RequestParam(value="regionName", required=false) String regionName) {
        try {
            return Result.ok(this.regionService.findRegionSelect(parentCode, regionName));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u4e0b\u7ea7\u7ec4\u7ec7\u4fe1\u606f")
    @GetMapping(value={"/findChildByParentCode"})
    public Result<List<Region>> findChildByParentCode(@RequestParam(value="parentCode", required=false) String parentCode) {
        try {
            return Result.ok(this.regionService.findChildByParentCode(parentCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

