/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.repository.RegionRepository;
import com.biz.crm.mdm.business.region.sdk.service.RegionVoService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="regionVoService")
public class RegionVoServiceImpl
implements RegionVoService {
    @Autowired(required=false)
    private RegionRepository regionRepository;

    public Map<String, String> findRegionCodeNameMap(List<String> regionCodeList) {
        List<Region> list = this.regionRepository.findByRegionCodes(regionCodeList);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(Region::getRegionCode, Region::getRegionName, (a, b) -> a));
    }

    public String findRegionCode(String regionName, String parentCode) {
        Region region = this.regionRepository.findByParentCodeAndRegionName(parentCode, regionName);
        if (Objects.isNull((Object)region)) {
            return null;
        }
        return region.getRegionCode();
    }
}

