package com.biz.crm.mdm.business.region.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.region.local.service.RegionLabelService;
import com.biz.crm.mdm.business.region.sdk.dto.RegionLabelDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author HanJiaJun
 * @describe:
 * @createTime 2022年08月02日 14:40:00
 */
@Slf4j
@RestController
@RequestMapping("/v1/regionLabel/regionLabel")
@Api(tags = "行政区域标签管理: Region: 行政区域标签管理")
public class RegionLabelController {
  @Autowired
  private RegionLabelService regionLabelService;


  /**
   * 绑定标签
   *
   * @return
   */
  @ApiOperation(value = "绑定标签")
  @PostMapping("")
  public Result<?> create(@RequestBody @ApiParam(name = "dto", value = "行政标签Dto") RegionLabelDto dto) {
    try {
      regionLabelService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 绑定标签
   *
   * @return
   */
  @ApiOperation(value = "删除标签")
  @DeleteMapping("")
  public Result<?> delete(@RequestParam("regionCodes") List<String> regionCodes) {
    try {
      regionLabelService.delete(regionCodes);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
