/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.region.local.service.internal;

import com.biz.crm.mdm.business.region.local.entity.Region;
import com.biz.crm.mdm.business.region.local.entity.RegionLabel;
import com.biz.crm.mdm.business.region.local.repository.RegionLabelRepository;
import com.biz.crm.mdm.business.region.local.service.RegionLabelService;
import com.biz.crm.mdm.business.region.local.service.RegionService;
import com.biz.crm.mdm.business.region.sdk.dto.RegionLabelDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegionLabelServiceImpl
implements RegionLabelService {
    @Autowired
    private RegionService regionService;
    @Autowired
    private RegionLabelRepository regionLabelRepository;

    @Override
    public void create(RegionLabelDto dto) {
        Validate.notNull((Object)dto, (String)"\u7ed1\u5b9a\u6807\u7b7e\u65f6\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getLabelList(), (String)"\u7ed1\u5b9a\u6807\u7b7e\u65f6\u6807\u7b7e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Collection)dto.getRegionCodeList(), (String)"\u7ed1\u5b9a\u6807\u7b7e\u65f6\u884c\u653f\u533a\u57df\u7f16\u7801\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Region> detailByCodes = this.regionService.findDetailByCodes(dto.getRegionCodeList());
        Validate.notEmpty(detailByCodes, (String)"\u672a\u7ef4\u62a4\u5f53\u524d\u884c\u653f\u533a\u57df\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        List ruleCodes = detailByCodes.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getRuleCode())).map(Region::getRuleCode).collect(Collectors.toList());
        ArrayList<Region> regions = new ArrayList<Region>();
        for (String ruleCode : ruleCodes) {
            List<Region> selfAndLowerByRuleCode = this.regionService.findSelfAndLowerByRuleCode(ruleCode);
            regions.addAll(selfAndLowerByRuleCode);
        }
        List<String> regionCodes = regions.stream().map(Region::getRegionCode).collect(Collectors.toList());
        this.deleteHandle(regionCodes);
        ArrayList<RegionLabel> res = new ArrayList<RegionLabel>();
        List labelList = dto.getLabelList();
        for (Region region : regions) {
            for (String label : labelList) {
                RegionLabel regionLabel = new RegionLabel();
                regionLabel.setRegionCode(region.getRegionCode());
                regionLabel.setRuleCode(region.getRuleCode());
                regionLabel.setLabel(label);
                res.add(regionLabel);
            }
        }
        this.regionLabelRepository.saveBatch(res);
    }

    private void deleteHandle(List<String> regionCodes) {
        Validate.notEmpty(regionCodes, (String)"\u5220\u9664\u6807\u7b7e\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.regionLabelRepository.deleteHandle(regionCodes);
    }

    @Override
    public void delete(List<String> regionCodes) {
        Validate.notEmpty(regionCodes, (String)"\u5220\u9664\u6807\u7b7e\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<Region> detailByCodes = this.regionService.findDetailByCodes(regionCodes);
        Validate.notEmpty(detailByCodes, (String)"\u672a\u7ef4\u62a4\u5f53\u524d\u884c\u653f\u533a\u57df\u7f16\u7801\u7684\u6570\u636e", (Object[])new Object[0]);
        List ruleCodes = detailByCodes.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getRuleCode())).map(Region::getRuleCode).collect(Collectors.toList());
        ArrayList<Region> regions = new ArrayList<Region>();
        for (String ruleCode : ruleCodes) {
            List<Region> selfAndLowerByRuleCode = this.regionService.findSelfAndLowerByRuleCode(ruleCode);
            regions.addAll(selfAndLowerByRuleCode);
        }
        List<String> allRegionCodes = regions.stream().map(Region::getRegionCode).collect(Collectors.toList());
        this.deleteHandle(allRegionCodes);
    }

    @Override
    public List<RegionLabel> findByRegionCodes(List<String> regionCodes) {
        if (CollectionUtils.isEmpty(regionCodes)) {
            return new ArrayList<RegionLabel>(0);
        }
        return this.regionLabelRepository.findByRegionCodes(regionCodes);
    }

    @Override
    public List<String> findRuleCodeByLabelList(List<String> labelList) {
        if (CollectionUtils.isEmpty(labelList)) {
            return new ArrayList<String>(0);
        }
        List<RegionLabel> labels = this.regionLabelRepository.findByLabelList(labelList);
        if (CollectionUtils.isEmpty(labels)) {
            return new ArrayList<String>(0);
        }
        Map<String, List<RegionLabel>> map = labels.stream().collect(Collectors.groupingBy(RegionLabel::getRuleCode));
        ArrayList<String> res = new ArrayList<String>();
        TreeSet<String> labelSet = new TreeSet<String>(labelList);
        map.forEach((k, v) -> {
            List dbLabel = v.stream().map(RegionLabel::getLabel).collect(Collectors.toList());
            TreeSet dbSet = new TreeSet(dbLabel);
            if (dbSet.equals(labelSet)) {
                res.add((String)k);
            }
        });
        return res;
    }
}

